/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.util;

import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public enum CredentialsProviderNameMapping {
    SYS("SystemPropertyCredentialsProvider"),
    ENV("EnvironmentVariableCredentialsProvider"),
    STSWEB("StsAssumeRoleWithWebIdentityCredentialsProvider"),
    STSROLE("StsAssumeRoleCredentialsProvider"),
    STSFED("StsGetFederationTokenCredentialsProvider"),
    SSO("SsoCredentialsProvider"),
    PROF("ProfileCredentialsProvider"),
    CONT("ContainerCredentialsProvider"),
    IMDS("InstanceProfileCredentialsProvider"),
    PROC("ProcessCredentialsProvider"),
    CPATH("ClasspathPropertiesFileCredentialsProvider"),
    UNKNOWN("Unknown");

    private static final Pattern CLASS_NAME_CHARACTERS;
    private static final Map<String, CredentialsProviderNameMapping> VALUE_MAP;
    private final String value;

    private CredentialsProviderNameMapping(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String mapFrom(String source) {
        if (StringUtils.isNullOrEmpty(source)) {
            return UNKNOWN.name().toLowerCase(Locale.US);
        }
        CredentialsProviderNameMapping shortName = CredentialsProviderNameMapping.mappedName(source);
        return shortName != null ? shortName.name().toLowerCase(Locale.US) : CredentialsProviderNameMapping.sanitizedProviderOrNull(source);
    }

    private static CredentialsProviderNameMapping mappedName(String value) {
        if (VALUE_MAP.containsKey(value)) {
            return VALUE_MAP.get(value);
        }
        return null;
    }

    private static String sanitizedProviderOrNull(String value) {
        return CredentialsProviderNameMapping.hasAcceptedFormat(value) ? value : null;
    }

    private static boolean hasAcceptedFormat(String input) {
        return CLASS_NAME_CHARACTERS.matcher(input).matches();
    }

    private static Map<String, CredentialsProviderNameMapping> mapNameToValue() {
        HashMap<String, CredentialsProviderNameMapping> map = new HashMap<String, CredentialsProviderNameMapping>();
        for (CredentialsProviderNameMapping mapping : CredentialsProviderNameMapping.values()) {
            String index = mapping.value();
            map.put(index, mapping);
        }
        return map;
    }

    static {
        CLASS_NAME_CHARACTERS = Pattern.compile("[a-zA-Z_$\\d]{0,62}");
        VALUE_MAP = CredentialsProviderNameMapping.mapNameToValue();
    }
}

