/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.scoring.Observation;
import com.dataiku.scoring.pipelines.Coercion;
import com.dataiku.scoring.pipelines.Normalization;
import com.dataiku.scoring.util.RawObservation;
import java.util.HashMap;
import java.util.Map;

public interface ObservationBuilder {

    public static class NormalizingCoercingBuilder
    extends RawBuilder {
        protected final Coercion coercion;
        protected final Normalization normalization;

        public NormalizingCoercingBuilder(Coercion coercion, Normalization normalization) {
            this.coercion = coercion;
            this.normalization = normalization;
        }

        @Override
        protected Observation.Builder withObject(String key, Object value) {
            return super.withObject(key, this.coercion.coerce(key, this.normalization.normalize(key, value)));
        }
    }

    public static class RawBuilder
    implements Observation.Builder {
        private final Map<String, Object> data = new HashMap<String, Object>();

        protected Observation.Builder withObject(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        @Override
        public Observation.Builder with(String key, String value) {
            return this.withObject(key, value);
        }

        @Override
        public Observation.Builder with(String key, Number value) {
            return this.withObject(key, value);
        }

        @Override
        public Observation.Builder withAll(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.with(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @Override
        public RawObservation build() {
            return new RawObservation(this.data);
        }
    }
}

