/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;

public final class DataStoreFinder {
    protected static final Logger LOGGER = Logging.getLogger(DataStoreFinder.class);
    private static volatile FactoryRegistry registry;

    private DataStoreFinder() {
    }

    public static synchronized DataStore getDataStore(Map<String, ?> params) throws IOException {
        Iterator<DataStoreFactorySpi> ps = DataStoreFinder.getAvailableDataStores();
        DataAccess<? extends FeatureType, ? extends Feature> dataStore = DataAccessFinder.getDataStore(params, ps);
        return (DataStore)dataStore;
    }

    public static synchronized Iterator<DataStoreFactorySpi> getAllDataStores() {
        return DataAccessFinder.getAllDataStores(DataStoreFinder.getServiceRegistry(), DataStoreFactorySpi.class);
    }

    public static synchronized Iterator<DataStoreFactorySpi> getAvailableDataStores() {
        FactoryRegistry serviceRegistry = DataStoreFinder.getServiceRegistry();
        Set<DataStoreFactorySpi> availableDS = DataAccessFinder.getAvailableDataStores(serviceRegistry, DataStoreFactorySpi.class);
        return availableDS.iterator();
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataStoreFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataStoreFactorySpi.class));
        }
        return registry;
    }

    public static synchronized void scanForPlugins() {
        DataStoreFinder.getServiceRegistry().scanForPlugins();
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }
}

