/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibtd.org.msgpack.value.impl;

import com.dataiku.dss.shadelibtd.org.msgpack.core.MessageFormat;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessageIntegerOverflowException;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessagePacker;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ImmutableIntegerValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ImmutableNumberValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.IntegerValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.Value;
import com.dataiku.dss.shadelibtd.org.msgpack.value.ValueType;
import com.dataiku.dss.shadelibtd.org.msgpack.value.impl.AbstractImmutableValue;
import com.dataiku.dss.shadelibtd.org.msgpack.value.impl.ImmutableBigIntegerValueImpl;
import java.io.IOException;
import java.math.BigInteger;

public class ImmutableLongValueImpl
extends AbstractImmutableValue
implements ImmutableIntegerValue {
    private final long value;
    private static final long BYTE_MIN = -128L;
    private static final long BYTE_MAX = 127L;
    private static final long SHORT_MIN = -32768L;
    private static final long SHORT_MAX = 32767L;
    private static final long INT_MIN = Integer.MIN_VALUE;
    private static final long INT_MAX = Integer.MAX_VALUE;

    public ImmutableLongValueImpl(long l) {
        this.value = l;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.INTEGER;
    }

    @Override
    public ImmutableIntegerValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableNumberValue asNumberValue() {
        return this;
    }

    @Override
    public ImmutableIntegerValue asIntegerValue() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public float toFloat() {
        return this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public boolean isInByteRange() {
        return -128L <= this.value && this.value <= 127L;
    }

    @Override
    public boolean isInShortRange() {
        return -32768L <= this.value && this.value <= 32767L;
    }

    @Override
    public boolean isInIntRange() {
        return Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isInLongRange() {
        return true;
    }

    @Override
    public MessageFormat mostSuccinctMessageFormat() {
        return ImmutableBigIntegerValueImpl.mostSuccinctMessageFormat(this);
    }

    @Override
    public byte asByte() {
        if (!this.isInByteRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (byte)this.value;
    }

    @Override
    public short asShort() {
        if (!this.isInShortRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (short)this.value;
    }

    @Override
    public int asInt() {
        if (!this.isInIntRange()) {
            throw new MessageIntegerOverflowException(this.value);
        }
        return (int)this.value;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packLong(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isIntegerValue()) {
            return false;
        }
        IntegerValue integerValue = value.asIntegerValue();
        if (!integerValue.isInLongRange()) {
            return false;
        }
        return this.value == integerValue.toLong();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE <= this.value && this.value <= Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public String toJson() {
        return Long.toString(this.value);
    }

    public String toString() {
        return this.toJson();
    }
}

