/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.hf.ModelCacheService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModelCacheAdminController
extends LambdaAPIControllerBase {
    @Autowired
    private ApiNodeAuthVerificationService authService;
    @Autowired
    private ModelCacheService modelCacheService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.admin.api");

    @AuditedCall(value={"msgType", "api-model-cache-import", "modelArchivePath", "${modelArchivePath}"})
    @RequestMapping(value={"/admin/api/model-cache"}, method={RequestMethod.POST})
    public void importModel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String modelArchivePath) throws Exception {
        this.authService.checkAdmin(req);
        logger.infoV("Importing model from the %s archive in model cache", new Object[]{modelArchivePath});
        ModelCacheService.ModelImportResult importResult = new ModelCacheService.ModelImportResult();
        try (InputStream modelArchiveInputStream = Files.newInputStream(Paths.get(modelArchivePath, new String[0]), new OpenOption[0]);
             AutoDelete extractedModel = DSSTempUtils.getTempFolder((String)"model-import", (String)SecretKeyGenerator.generate((int)16));){
            logger.info((Object)("Extracting archive to: " + extractedModel.getAbsolutePath()));
            DKUFileUtils.unzipInputStream((File)extractedModel, (InputStream)modelArchiveInputStream);
            this.modelCacheService.importModel((AuthCtx)DSSAuthCtx.newNone(), (File)extractedModel, importResult);
        }
        ModelCacheAdminController.writeJSON(resp, importResult);
    }

    @AuditedCall(value={"msgType", "api-model-cache-clear"})
    @RequestMapping(value={"/admin/api/model-cache"}, method={RequestMethod.DELETE})
    public void clearCache(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        this.authService.checkAdmin(req);
        logger.infoV("Clearing model cache", new Object[0]);
        this.modelCacheService.clear();
        this.writeSimpleOK(resp);
    }
}

