/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.lambda.model.api.LookupModel;
import com.dataiku.lambda.model.api.SinglePredictionQuery;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.json.JSONObject;

public class LambdaControllerUtils {
    private static JsonPrimitive jsonify(String ev) {
        Object val = JSONObject.stringToValue((String)ev);
        if (val instanceof Number) {
            return new JsonPrimitive((Number)val);
        }
        if (val instanceof Boolean) {
            return new JsonPrimitive((Boolean)val);
        }
        return new JsonPrimitive(ev);
    }

    public static JsonObject makeObjectFromReqParams(Map<String, String[]> reqParams) {
        JsonObject o = new JsonObject();
        for (Map.Entry<String, String[]> e : reqParams.entrySet()) {
            if (e.getValue() == null || e.getValue().length <= 0) continue;
            if (e.getValue().length == 1) {
                o.add(e.getKey(), (JsonElement)LambdaControllerUtils.jsonify(e.getValue()[0]));
                continue;
            }
            JsonArray arr = new JsonArray();
            for (String ev : e.getValue()) {
                arr.add((JsonElement)LambdaControllerUtils.jsonify(ev));
            }
            o.add(e.getKey(), (JsonElement)arr);
        }
        return o;
    }

    static SinglePredictionQuery httpGETReqToPredictionQuery(HttpServletRequest req) {
        SinglePredictionQuery spq = new SinglePredictionQuery();
        spq.features = LambdaControllerUtils.makeObjectFromReqParams(req.getParameterMap());
        return spq;
    }

    static LookupModel.SingleLookupQuery httpGETReqToLookupQuery(HttpServletRequest req) {
        LookupModel.SingleLookupQuery spq = new LookupModel.SingleLookupQuery();
        spq.data = LambdaControllerUtils.makeObjectFromReqParams(req.getParameterMap());
        return spq;
    }
}

