/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.dispatch;

import com.dataiku.lambda.dispatch.GenerationSelector;
import com.dataiku.lambda.model.api.PredictionQueryDispatch;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.StringUtils;

public class RandomGenerationSelector
implements GenerationSelector {
    private Random random = new Random();
    public List<Double> bounds = new ArrayList<Double>();
    public List<String> gens = new ArrayList<String>();

    public RandomGenerationSelector(GenerationsMapping mapping) {
        double cur = 0.0;
        for (GenerationsMapping.MappingEntry e : mapping.getEntries()) {
            this.bounds.add(cur += e.proba);
            this.gens.add(e.generation);
        }
    }

    @Override
    public String select(PredictionQueryDispatch dispatch) {
        if (dispatch != null && !StringUtils.isBlank((String)dispatch.forcedGeneration)) {
            return dispatch.forcedGeneration;
        }
        double rnd = this.random.nextDouble();
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!(rnd < this.bounds.get(i))) continue;
            return this.gens.get(i);
        }
        throw new Error("failed to select " + rnd);
    }
}

