/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints;

import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.model.api.ResponseElements;
import com.dataiku.lambda.model.serverconfig.EndpointServerSideConfig;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.services.ServiceManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class LambdaEndpointHandler<C extends LambdaEndpointConfig> {
    protected final C config;
    protected EndpointServerSideConfig serverEndpointConfig;
    protected ServiceGenContext context;
    @Autowired
    protected AuditTrailService auditTrailService;
    @Autowired
    protected LambdaContext lmContext;

    public LambdaEndpointHandler(C config) {
        this.config = config;
    }

    public void init(ServiceGenContext context) throws Exception {
        this.context = context;
        this.serverEndpointConfig = context.getServerEndpointConfig(((LambdaEndpointConfig)this.config).id);
    }

    public abstract void destroy();

    public ResponseElements.Context newContext() {
        ResponseElements.Context c = new ResponseElements.Context();
        c.endpointId = ((LambdaEndpointConfig)this.config).id;
        c.serviceId = this.context.getServiceId();
        c.serviceGeneration = this.context.getGenerationId();
        return c;
    }

    protected abstract String getMessageType();

    protected abstract String getQueryType();

    protected String getInputPropertyName() {
        return "input";
    }

    protected Optional<AuditTrailService.EmittableAuditObj> createEvent(ServiceManager.RefcountedEndpoint re, DKULogger logger, JsonObject input, AuditResult output, Exception error, String timing, String apiContext) {
        LambdaServerConfig.AuditLog al = this.lmContext.getAuditConfig();
        if (al.logQueries) {
            AuditTrailService.EmittableAuditObj geo = this.auditTrailService.emittable("apinode-query", re.getActiveMapping().auditRoutingKey).with("msgType", this.getMessageType()).with("apinodeQueryType", this.getQueryType()).with("serviceId", this.context.getServiceId()).with("endpointId", ((LambdaEndpointConfig)this.config).id).with("serviceGenerationId", this.context.getGenerationId()).withAll(re.getActiveMapping().auditMetadata);
            if (timing != null) {
                geo.with("timing", (JsonObject)JSON.parse((String)timing, JsonObject.class));
            }
            if (apiContext != null) {
                geo.with("apiContext", (JsonObject)JSON.parse((String)apiContext, JsonObject.class));
            }
            if (al.logInputs && input != null) {
                geo.with(this.getInputPropertyName(), input);
            }
            if (al.logOutputs && output != null) {
                output.addOutput(geo);
            }
            if (error != null) {
                geo.with("error", error.getMessage());
            }
            return Optional.of(geo);
        }
        return Optional.empty();
    }

    protected AuditResult createResult(String s) {
        return new StringAuditResult(s);
    }

    protected AuditResult createResult(JsonObject obj) {
        return new JSONAuditResult(obj);
    }

    protected AuditResult createResult(JsonArray elt) {
        return new JSONArrayAuditResult(elt);
    }

    protected static interface AuditResult {
        public void addOutput(AuditTrailService.EmittableAuditObj var1);
    }

    static class StringAuditResult
    implements AuditResult {
        private String out;

        public StringAuditResult(String out) {
            this.out = out;
        }

        @Override
        public void addOutput(AuditTrailService.EmittableAuditObj geo) {
            geo.with("result", this.out);
        }
    }

    static class JSONAuditResult
    implements AuditResult {
        private JsonObject out;

        public JSONAuditResult(JsonObject out) {
            this.out = out;
        }

        @Override
        public void addOutput(AuditTrailService.EmittableAuditObj geo) {
            geo.with("result", this.out);
        }
    }

    static class JSONArrayAuditResult
    implements AuditResult {
        private JsonArray out;

        public JSONArrayAuditResult(JsonArray out) {
            this.out = out;
        }

        @Override
        public void addOutput(AuditTrailService.EmittableAuditObj geo) {
            geo.get().add("results", (JsonElement)this.out);
        }
    }
}

