/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.predict;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.scoring.Predictor;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.LambdaAPICodes;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.endpoints.predictcommon.PredictionStep;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.scoring.builders.Build;
import com.dataiku.scoring.builders.ObservationBuilder;
import com.dataiku.scoring.util.RawObservation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class JavaPredictionStep
implements PredictionStep {
    private final Predictor predictor;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.prediction.step");

    public JavaPredictionStep(File modelFolder) throws IOException {
        URL modelURL = modelFolder.toURI().toURL();
        Build.DssPipelineMeta meta = Build.pipelineMeta((URL)modelURL);
        this.predictor = new Predictor(modelFolder);
    }

    @Override
    public PredictionResponse process(PipelineMessage message) throws Exception {
        if (message.explanations != null && Boolean.TRUE.equals(message.explanations.enabled)) {
            throw new CodedException((InfoMessage.MessageCode)LambdaAPICodes.ERR_APINODE_ENDPOINT_NOT_COMPATIBLE, "Cannot output individual explanations using Java scoring");
        }
        MemTable table = message.table;
        ArrayList<PredictionResponse.PredictionResponseItem> items = new ArrayList<PredictionResponse.PredictionResponseItem>(table.rows.size());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating samples (" + table.nrows() + " created)"));
        }
        Iterable columns = table.columns();
        for (int i = 0; i < message.prePredictIgnoreReasons.size(); ++i) {
            if (message.prePredictIgnoreReasons.get(i) != null) {
                PredictionResponse.PredictionResponseItem item = new PredictionResponse.PredictionResponseItem();
                item.ignored = true;
                item.ignoreReason = message.prePredictIgnoreReasons.get(i);
                items.add(item);
                continue;
            }
            Row r = (Row)table.rows.get(i);
            ObservationBuilder.NormalizingCoercingBuilder builder = this.predictor.getNormalizingCoercingBuilder();
            for (Column col : columns) {
                builder.with(col.getName(), r.get(col));
            }
            RawObservation s = builder.build();
            items.add(this.predictor.predict(s));
        }
        PredictionResponse resp = new PredictionResponse();
        resp.results = items;
        return resp;
    }

    @Override
    public void destroy() {
    }
}

