/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherChildAnchorRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherClientAnchorRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherContainerRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ddf.EscherRecord;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFChildAnchor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.ChildAnchor;

public abstract class HSSFAnchor
implements ChildAnchor {
    protected boolean _isHorizontallyFlipped;
    protected boolean _isVerticallyFlipped;

    public HSSFAnchor() {
        this.createEscherAnchor();
    }

    public HSSFAnchor(int dx1, int dy1, int dx2, int dy2) {
        this.createEscherAnchor();
        this.setDx1(dx1);
        this.setDy1(dy1);
        this.setDx2(dx2);
        this.setDy2(dy2);
    }

    public static HSSFAnchor createAnchorFromEscher(EscherContainerRecord container) {
        if (null != container.getChildById(EscherChildAnchorRecord.RECORD_ID)) {
            return new HSSFChildAnchor((EscherChildAnchorRecord)container.getChildById(EscherChildAnchorRecord.RECORD_ID));
        }
        if (null != container.getChildById(EscherClientAnchorRecord.RECORD_ID)) {
            return new HSSFClientAnchor((EscherClientAnchorRecord)container.getChildById(EscherClientAnchorRecord.RECORD_ID));
        }
        return null;
    }

    public abstract boolean isHorizontallyFlipped();

    public abstract boolean isVerticallyFlipped();

    protected abstract EscherRecord getEscherAnchor();

    protected abstract void createEscherAnchor();
}

