/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.autorestart.AutoRestartingLoopThread;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.ContinuousActivitiesPersistentStateDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/continuous-activities"})
public class PublicAPIContinuousActivitiesController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private RecipesDAO recipesDAO;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.continuousActivities");

    @AuditedCall(value={"msgType", "continuous-activities-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState> listContinuousActivities(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List activities = this.continuousActivitiesManager.listProjectPersistentStates_T(projectKey);
            HashSet recipeIds = Sets.newHashSet();
            for (ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState activity : activities) {
                recipeIds.add(activity.recipeId);
            }
            for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(projectKey)) {
                try {
                    RecipeMeta meta = RecipeRegistry.getMeta((SerializedRecipe)recipe);
                    if (!meta.isContinuous() || recipeIds.contains(recipe.name)) continue;
                    ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState activity = new ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState();
                    activity.projectKey = projectKey;
                    activity.recipeId = recipe.name;
                    activity.recipeType = recipe.type;
                    activity.desiredState = ContinuousActivitiesPersistentStateDAO.DesiredState.STOPPED;
                    activities.add(activity);
                }
                catch (Throwable e) {
                    logger.warn((Object)("Invalid recipe : " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            List list = activities;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "continuous-activities-get", "projectKey", "${projectKey}", "recipeId", "${recipeId}"})
    @RequestMapping(value={"/{recipeId}/"}, method={RequestMethod.GET})
    public void getState(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeId) throws Exception {
        boolean keepFutureIds = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIds = true;
            } else {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
        }
        ContinuousActivitiesManager.ContinuousActivityCurrentState state = this.continuousActivitiesManager.getState(projectKey, recipeId);
        if (!keepFutureIds) {
            state.stripFutureIds();
        }
        PublicAPIContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)state);
    }

    @AuditedCall(value={"msgType", "continuous-activities-start", "projectKey", "${projectKey}", "recipeId", "${recipeId}"})
    @RequestMapping(value={"/{recipeId}/start"}, method={RequestMethod.POST})
    public void start(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeId) throws Exception {
        AuthCtx authCtx;
        AutoRestartingLoopThread.AutoRestartingLoopParams loopParams;
        block8: {
            loopParams = (AutoRestartingLoopThread.AutoRestartingLoopParams)this.getRequestBodyAs(req, AutoRestartingLoopThread.AutoRestartingLoopParams.class);
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getTicketOrKey(req);
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
                SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeId);
                if (RecipeRegistry.hasMeta((SerializedRecipe)recipe)) {
                    if (!RecipeRegistry.getMeta((SerializedRecipe)recipe).isContinuous()) {
                        throw new IllegalArgumentException("Recipe is not continuous: " + recipe.type);
                    }
                    break block8;
                }
                throw new IllegalArgumentException("Unknown recipe type : " + recipe.type);
            }
        }
        PublicAPIContinuousActivitiesController.writeJSON((HttpServletResponse)resp, (Object)this.continuousActivitiesManager.start_NT(authCtx, projectKey, recipeId, loopParams));
    }

    @AuditedCall(value={"msgType", "continuous-activities-stop", "projectKey", "${projectKey}", "recipeId", "${recipeId}"})
    @RequestMapping(value={"/{recipeId}/stop"}, method={RequestMethod.POST})
    public void stop(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String recipeId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.continuousActivitiesManager.stop_NT(authCtx, projectKey, recipeId);
    }
}

