/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.futures.FutureHistoryService;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnablesService;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/runnables"})
public class PublicAPIRunnablesController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DSSRunnablesService dssRunnablesService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private FutureHistoryService futureHistoryService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    private int lastRunId = 0;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.runnables");

    private synchronized int makeRunId() {
        return this.lastRunId++;
    }

    @AuditedCall(value={"msgType", "runnables-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listJobs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            ArrayList ret = Lists.newArrayList();
            for (LoadedRunnable runnable : this.dssRunnablesService.listRunnables()) {
                if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) continue;
                ret.add(new RunnableItem(runnable, authCtx.isAdmin()));
            }
            PublicAPIRunnablesController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "runnable-get", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/{runnableType:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String runnableType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LoadedRunnable runnable = this.dssRunnablesService.getRunnable(runnableType);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
            PublicAPIRunnablesController.writeJSON((HttpServletResponse)resp, (Object)new RunnableItem(runnable, authCtx.isAdmin()));
        }
    }

    @AuditedCall(value={"msgType", "runnable-run", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/{runnableType}"}, method={RequestMethod.POST})
    public void run(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String runnableType, @RequestParam(required=false, defaultValue="false") boolean wait) throws Exception {
        FutureResponse fr;
        String historyPrefix;
        RunnableParams params = (RunnableParams)this.getRequestBodyAs(req, RunnableParams.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LoadedRunnable runnable = this.dssRunnablesService.getRunnable(runnableType);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
            if (!authCtx.isAdmin()) {
                params.adminParams = new JsonObject();
            }
            int runId = this.makeRunId();
            File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType + "_" + runId));
            historyPrefix = this.runnableHistoryPrefix(projectKey, runnableType, runId);
            this.futureHistoryService.removeWithPrefix(historyPrefix);
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, (String)projectKey, null, null, null));
            fr = this.dssRunnablesService.run(runnableType, authCtx, projectKey, params.params, params.adminParams, contextDir);
            this.futureHistoryService.register(historyPrefix, fr, new String[]{"projectKey", projectKey, "runnableType", runnableType, "runId", Integer.toString(runId)});
        }
        if (wait && !fr.hasResult) {
            this.futureService.waitForCompletion(fr.jobId);
        }
        PublicAPIRunnablesController.writeJSON((HttpServletResponse)resp, (Object)new RunnableRunId(historyPrefix));
    }

    private String runnableHistoryPrefix(String projectKey, String runnableType, int runId) {
        return "runnables:" + projectKey + ":" + runnableType + ":" + runId;
    }

    private int getRunIdFromRunnableHistoryPrefix(String projectKey, String runnableType, String historyPrefix) {
        String prefix = "runnables:" + projectKey + ":" + runnableType + ":";
        if (historyPrefix.length() <= prefix.length()) {
            throw new IllegalArgumentException("Malformed runId");
        }
        try {
            return Integer.parseInt(historyPrefix.substring(prefix.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Malformed runId", e);
        }
    }

    @AuditedCall(value={"msgType", "runnable-abort", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/{runnableType}/abort/{run:.+}"}, method={RequestMethod.POST})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String runnableType, @PathVariable String run) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LoadedRunnable runnable = this.dssRunnablesService.getRunnable(runnableType);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
        }
        List running = this.futureHistoryService.getAllByPrefix(run);
        if (running.isEmpty()) {
            throw new IllegalArgumentException("Macro is not running anymore");
        }
        this.futureHistoryService.removeWithPrefix(run);
        for (FutureHistoryService.FutureHistoryItem item : running) {
            this.futureService.abort(item.jobId);
        }
    }

    @AuditedCall(value={"msgType", "runnable-get", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/{runnableType}/state/{run:.+}"}, method={RequestMethod.GET})
    public void peek(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String runnableType, @PathVariable String run) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            LoadedRunnable runnable = this.dssRunnablesService.getRunnable(runnableType);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
        }
        RunnableRunState ret = new RunnableRunState();
        List running = this.futureHistoryService.getAllByPrefix(run);
        if (running.isEmpty()) {
            ret.exists = false;
        } else {
            FutureHistoryService.FutureHistoryItem item = (FutureHistoryService.FutureHistoryItem)running.get(0);
            ret.exists = true;
            if (item.storedError != null) {
                ret.running = false;
                ret.storedError = item.storedError;
            } else if (item.lastResponse == null || !item.lastResponse.hasResult) {
                ret.running = true;
                ret.progress = item.lastResponse.progress;
            } else if (item.lastResponse.result == null) {
                ret.running = false;
                ret.empty = true;
            } else {
                DSSRunnableResult result = (DSSRunnableResult)item.lastResponse.result;
                ret.type = result.type;
            }
        }
        PublicAPIRunnablesController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "runnable-result-get", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/{runnableType}/result/{run:.+}"}, method={RequestMethod.GET})
    public void getResult(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String runnableType, @PathVariable String run) throws Exception {
        block32: {
            ResultInfo result = null;
            try {
                try (Transaction t = this.transactionService.beginRead();){
                    AuthCtx authCtx = this.authService.getTicketOrKey(req);
                    this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
                    LoadedRunnable runnable = this.dssRunnablesService.getRunnable(runnableType);
                    if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                        throw new SecurityException("Insufficient permissions to run " + runnableType);
                    }
                    result = this.getNonErrorResult(authCtx, projectKey, runnableType, run);
                    this.futureHistoryService.removeWithPrefix(run);
                }
                if (result.storedError != null) {
                    this.returnErrorResult(resp, result.storedError);
                    break block32;
                }
                if (result.resultError != null) {
                    this.returnErrorResult(resp, result.resultError);
                    break block32;
                }
                if (result.empty) {
                    PublicAPIRunnablesController.writeJSON((HttpServletResponse)resp, (Object)"");
                    break block32;
                }
                if (result.content != null) {
                    resp.setStatus(200);
                    resp.setContentType(StringUtils.defaultIfBlank((String)result.mimeType, (String)"text/plain"));
                    if (StringUtils.isNotBlank((String)result.fileName)) {
                        resp.setHeader("Content-Disposition", "attachment; filename=\"" + result.fileName + "\"");
                    }
                    try (BufferedOutputStream os = new BufferedOutputStream((OutputStream)resp.getOutputStream());){
                        IOUtils.copy((InputStream)result.content, (OutputStream)os);
                        break block32;
                    }
                }
                throw new IllegalArgumentException("Failed to retrieve the result of the macro, because there is no content");
            }
            finally {
                if (result != null && result.content != null) {
                    if (result.content != null) {
                        try {
                            result.content.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to close stream of macro result", (Throwable)e);
                        }
                    }
                    if (result.handler != null) {
                        try {
                            result.handler.close();
                        }
                        catch (Exception e) {
                            logger.error((Object)"Failed to close folder handler containing macro result", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void returnErrorResult(HttpServletResponse resp, WarningsContext.SerializedThrowable resultError) throws IOException {
        APIError error = new APIError();
        error.errorType = resultError.clazz;
        error.message = resultError.message;
        error.stackTraceStr = resultError.stack;
        this.returnErrorResult(resp, (SerializedError)error);
    }

    private void returnErrorResult(HttpServletResponse resp, SerializedError error) throws IOException {
        resp.setStatus(500);
        resp.setContentType("application/json");
        PublicAPIRunnablesController.writeJsonToOutputStream((HttpServletResponse)resp, (Object)error);
    }

    private ResultInfo getNonErrorResult(AuthCtx authCtx, String projectKey, String runnableType, String historyPrefix) throws Exception {
        List running = this.futureHistoryService.getAllByPrefix(historyPrefix);
        if (running.isEmpty()) {
            throw new IllegalArgumentException("Macro is not running anymore or the result has already been retrieved");
        }
        FutureHistoryService.FutureHistoryItem item = (FutureHistoryService.FutureHistoryItem)running.get(0);
        if (item.lastResponse == null || !item.lastResponse.hasResult) {
            throw new IllegalArgumentException("Macro is still running");
        }
        ResultInfo ret = new ResultInfo();
        if (item.storedError != null) {
            ret.storedError = item.storedError;
        } else if (item.lastResponse.result == null) {
            ret.empty = true;
        } else {
            DSSRunnableResult result = (DSSRunnableResult)item.lastResponse.result;
            if (result.error != null) {
                ret.resultError = result.error;
            } else if (result.failure != null) {
                ret.resultError = result.failure;
            } else {
                int runId = this.getRunIdFromRunnableHistoryPrefix(projectKey, runnableType, historyPrefix);
                File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType + "_" + runId));
                if (result.data != null) {
                    switch (result.type) {
                        case FILE: {
                            ReportTargetItem.KeptFileItem typed = (ReportTargetItem.KeptFileItem)result.data;
                            File file = new File(contextDir, typed.path);
                            ret.mimeType = typed.mimeType;
                            ret.fileName = file.getName();
                            ret.content = new FileInputStream(file);
                            break;
                        }
                        case FOLDER_FILE: {
                            ReportTargetItem.ManagedFolderFileItem typed = (ReportTargetItem.ManagedFolderFileItem)result.data;
                            ManagedFolder managedFolder = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(typed.projectKey, typed.folderId);
                            ret.handler = (ManagedFolderHandler)managedFolder.buildHandler(authCtx);
                            ret.fileName = (String)PathUtils.splitBasename((String)typed.itemPath).second;
                            ret.mimeType = DKUtils.guessMimeTypeFromExtension((String)ret.fileName);
                            ret.content = ret.handler.getInputStream(typed.itemPath).rawStream();
                            break;
                        }
                        case URL: {
                            ret.content = new ByteArrayInputStream(((ReportTargetItem.UrlItem)result.data).url.getBytes(StandardCharsets.UTF_8));
                            break;
                        }
                        case JSON_OBJECT: {
                            ret.content = new ByteArrayInputStream(JSON.pretty((Object)((ReportTargetItem.JsonObjectItem)result.data).object).getBytes(StandardCharsets.UTF_8));
                            break;
                        }
                        case HTML: {
                            ret.fileName = "result.html";
                            ret.mimeType = "application/html";
                            if (result.data instanceof ReportTargetItem.InlineHtmlItem) {
                                ret.content = new ByteArrayInputStream(((ReportTargetItem.InlineHtmlItem)result.data).data.getBytes(StandardCharsets.UTF_8));
                                break;
                            }
                            File htmlFile = new File(contextDir, ((ReportTargetItem.KeptFileItem)result.data).path);
                            ret.content = new FileInputStream(htmlFile);
                            break;
                        }
                        case RESULT_TABLE: {
                            ret.fileName = "result.table";
                            ret.mimeType = "application/vnd.dataiku.resulttable";
                            if (result.data instanceof ReportTargetItem.InlineResultTableItem) {
                                ret.content = new ByteArrayInputStream(JSON.json((Object)((ReportTargetItem.InlineResultTableItem)result.data).table).getBytes(StandardCharsets.UTF_8));
                                break;
                            }
                            File tableFile = new File(contextDir, ((ReportTargetItem.KeptFileItem)result.data).path);
                            ret.content = new FileInputStream(tableFile);
                            break;
                        }
                        case NONE: {
                            ret.empty = true;
                        }
                    }
                }
            }
        }
        return ret;
    }

    public static class RunnableItem {
        public String runnableType;
        public String ownerPluginId;
        public DkuComponentMetadata meta;
        public String longDescription;
        public DSSRunnableResult.ResultType resultType;
        public String extension;
        public String mimeType;
        public String resultLabel;
        public List<ParamDesc> params = new ArrayList<ParamDesc>();
        public List<ParamDesc> adminParams = new ArrayList<ParamDesc>();

        public RunnableItem(LoadedRunnable<?> runnable, boolean withAdminParams) {
            this.runnableType = runnable.runnableType;
            this.ownerPluginId = runnable.ownerPluginId;
            this.meta = runnable.desc.meta;
            this.longDescription = runnable.desc.longDescription;
            this.resultType = runnable.desc.resultType;
            this.extension = runnable.desc.extension;
            this.mimeType = runnable.desc.mimeType;
            this.resultLabel = runnable.desc.resultLabel;
            this.params.addAll(runnable.desc.params);
            if (withAdminParams) {
                this.adminParams.addAll(runnable.desc.adminParams);
            }
        }
    }

    public static class RunnableParams {
        public JsonObject params = new JsonObject();
        public JsonObject adminParams = new JsonObject();
    }

    public static class RunnableRunId {
        public String runId;

        public RunnableRunId(String runId) {
            this.runId = runId;
        }
    }

    public static class RunnableRunState {
        public boolean exists;
        public boolean running;
        public SerializedError storedError;
        public APIError resultError;
        public boolean empty;
        public DSSRunnableResult.ResultType type;
        public FutureProgressStateSnapshot progress;
    }

    private static class ResultInfo {
        boolean empty;
        String mimeType;
        String fileName;
        InputStream content;
        SerializedError storedError;
        WarningsContext.SerializedThrowable resultError;
        ManagedFolderHandler handler;

        private ResultInfo() {
        }
    }
}

