/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.discussions.InboxService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.IndexNotBuiltException;
import com.dataiku.dip.server.services.catalog.IndexingDisabledException;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/inbox"})
public class InboxController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private InboxService inboxService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.discussions.inbox");

    @AuditedCall(value={"msgType", "inbox-search", "query", "${query}", "facets", "${facets}", "type", "${type}"})
    @RequestMapping(value={"/search"})
    public void search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam String facets, @Nullable String explainDocId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        Map facetMap = (Map)JSON.parse((String)facets, (TypeToken)new TypeToken<Map<String, List<String>>>(){});
        try {
            InboxService.InboxSearchResponse response = this.inboxService.search(query, facetMap, user, explainDocId);
            InboxController.writeJSON((HttpServletResponse)resp, (Object)response);
        }
        catch (IndexNotBuiltException e) {
            logger.info((Object)("Index not built yet, " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            InboxController.sendErrorExplicit((int)503, (String)"NotReady", (String)"Data catalog is not ready yet (indexing)", (HttpServletResponse)resp);
        }
        catch (IndexingDisabledException e) {
            InboxController.sendErrorExplicit((int)503, (String)"Disabled", (String)"Indexing is disabled", (HttpServletResponse)resp);
        }
    }
}

