/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.external;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.ExternalTable;
import com.dataiku.dip.dao.impl.ExternalCatalogInternalDB;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.LimitedTo200QueryExecutor;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.external.ExternalTableSummary;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ExternalTableController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    ExternalCatalogInternalDB externalTableDAO;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ExternalDataCatalogService catalogService;

    @AuditedCall(value={"msgType", "external-table-get-summary", "connection", "${connection}", "catalog", "${catalog}", "schema", "${schema}", "table", "${table}"})
    @RequestMapping(value={"/api/external-table/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection, @RequestParam(required=false) String catalog, @RequestParam(required=false) String schema, @RequestParam String table) throws Exception {
        Set<String> allowedProjects;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.connectionsService.checkUserForConnection(authCtx, connection);
            allowedProjects = this.getAllowedProjects(authCtx);
        }
        LuceneResponseWrapper indexedExternalTable = this.catalogService.getExternalTable(connection, catalog, schema, table);
        if (indexedExternalTable.totalHits.value == 0L) {
            throw new NotFoundException("Unknown table");
        }
        Map source = ((LuceneResponseWrapper.Hit)indexedExternalTable.hits.get((int)0))._source;
        ExternalTable externalTable = (ExternalTable)JSON.parse((String)JSON.json(source.get("rawTable")), ExternalTable.class);
        ExternalCatalogInternalDB.ExternalTableDSSMetadata dssMetadata = this.externalTableDAO.getDSSMetadata(externalTable.key);
        if (dssMetadata != null) {
            externalTable.description = dssMetadata.description;
            externalTable.tags = dssMetadata.tags;
        }
        ExternalTableSummary.DSSItemsResponse itemsResp = (ExternalTableSummary.DSSItemsResponse)JSON.parse((String)JSON.json(source.get("rawRelatedItems")), ExternalTableSummary.DSSItemsResponse.class);
        List publicUsers = source.containsKey("users") ? (List)JSON.parse((String)JSON.json(source.get("users")), (TypeToken)new TypeToken<List<PublicUser>>(){}) : List.of();
        ListIterator<ExternalTableSummary.DSSItemsProject> it = itemsResp.projects.listIterator();
        while (it.hasNext()) {
            ExternalTableSummary.DSSItemsProject p = it.next();
            if (allowedProjects.contains(p.key)) continue;
            it.remove();
        }
        ExternalTableSummary result = new ExternalTableSummary(externalTable, publicUsers, itemsResp);
        ExternalTableController.writeJSONString((HttpServletResponse)resp, (String)JSON.json((Object)result));
    }

    private Set<String> getAllowedProjects(AuthCtx user) throws DKUSecurityException, IOException {
        HashSet<String> allowedProjects = new HashSet<String>();
        for (String projectKey : this.projectsService.listKeys()) {
            if (!this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            allowedProjects.add(projectKey);
        }
        return allowedProjects;
    }

    @AuditedCall(value={"msgType", "external-table-get-metadata", "connection", "${connection}", "catalog", "${catalog}", "schema", "${schema}", "table", "${table}"})
    @RequestMapping(value={"/api/external-table/get-metadata"})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection, @RequestParam(required=false) String catalog, @RequestParam(required=false) String schema, @RequestParam String table) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.connectionsService.checkUserForConnection(authCtx, connection);
        }
        DatabaseObjectKey key = new DatabaseObjectKey(connection, catalog, schema, table);
        ExternalCatalogInternalDB.ExternalTableDSSMetadata dssMetadata = this.externalTableDAO.getDSSMetadata(key);
        if (dssMetadata == null) {
            dssMetadata = new ExternalCatalogInternalDB.ExternalTableDSSMetadata();
        }
        ExternalTableController.writeJSON((HttpServletResponse)resp, (Object)dssMetadata);
    }

    @AuditedCall(value={"msgType", "external-table-save-metadata", "connection", "${connection}", "catalog", "${catalog}", "schema", "${schema}", "table", "${table}"})
    @RequestMapping(value={"/api/external-table/save-metadata"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection, @RequestParam(required=false) String catalog, @RequestParam(required=false) String schema, @RequestParam String table, @RequestParam String dssMetadata) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.connectionsService.checkUserForConnection(liu, connection);
        }
        DatabaseObjectKey dok = new DatabaseObjectKey(connection, catalog, schema, table);
        ExternalCatalogInternalDB.ExternalTableDSSMetadata mdObj = (ExternalCatalogInternalDB.ExternalTableDSSMetadata)JSON.parse((String)dssMetadata, ExternalCatalogInternalDB.ExternalTableDSSMetadata.class);
        this.externalTableDAO.updateDSSMetadata(dok, mdObj);
    }

    @AuditedCall(value={"msgType", "external-table-preview", "connection", "${connection}", "catalog", "${catalog}", "schema", "${schema}", "table", "${table}"})
    @RequestMapping(value={"/api/external-table/preview"})
    public void testExternalTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connection, @RequestParam(required=false) String catalog, @RequestParam(required=false) String schema, @RequestParam String table, @RequestParam(value="maxSamples", defaultValue="15", required=false) int maxSamples) throws Exception {
        AuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.connectionsService.checkUserForConnection(liu, connection);
        }
        SQLConnectionProvider.SQLConnectionData connectionData = SQLConnectionProvider.getConnectionData_NT((AuthCtx)liu, null, (String)connection);
        QueryRunResult exec = LimitedTo200QueryExecutor.queryTableSample((SQLDialect)connectionData.getDialect(), (String)connection, (String)catalog, (String)schema, (String)table, (int)100, (AuthCtx)liu, null);
        ExternalTableController.writeJSON((HttpServletResponse)resp, (Object)exec);
    }
}

