/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal.parquet;

import io.delta.kernel.defaults.internal.DefaultKernelUtils;
import io.delta.kernel.defaults.internal.parquet.ParquetColumnReaders;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneOffset;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TimestampConverters {
    public static Converter createTimestampConverter(int n, Type type, DataType dataType) {
        PrimitiveType primitiveType = type.asPrimitiveType();
        LogicalTypeAnnotation logicalTypeAnnotation = primitiveType.getLogicalTypeAnnotation();
        boolean bl = dataType instanceof TimestampType;
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return new TimestampBinaryConverter(dataType, n);
        }
        if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64 && logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalTypeAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation;
            boolean bl2 = timestampLogicalTypeAnnotation.isAdjustedToUTC();
            if (!(bl && bl2 || !bl && !bl2)) {
                throw new RuntimeException(String.format("Incompatible Utc adjustment for timestamp column. Client type: %s, File type: %s, isAdjustedUtc: %s", dataType, type, bl2));
            }
            switch (timestampLogicalTypeAnnotation.getUnit()) {
                case MICROS: {
                    return new ParquetColumnReaders.LongColumnReader(dataType, n);
                }
                case MILLIS: {
                    return new TimestampMillisConverter(dataType, n);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported Parquet TimeType unit=%s", timestampLogicalTypeAnnotation.getUnit()));
        }
        if (dataType == TimestampNTZType.TIMESTAMP_NTZ && primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32 && logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return new DateToTimestampNTZConverter(dataType, n);
        }
        throw new RuntimeException(String.format("Unsupported timestamp column with Parquet type %s.", type));
    }

    private static DataType validTimestampType(DataType dataType) {
        Preconditions.checkArgument((dataType instanceof TimestampType || dataType instanceof TimestampNTZType ? 1 : 0) != 0);
        return dataType;
    }

    public static class DateToTimestampNTZConverter
    extends ParquetColumnReaders.LongColumnReader {
        DateToTimestampNTZConverter(DataType dataType, int n) {
            super(TimestampConverters.validTimestampType(dataType), n);
        }

        @Override
        public void addInt(int n) {
            super.addLong(DefaultKernelUtils.daysToMicros(n, ZoneOffset.UTC));
        }
    }

    public static class TimestampBinaryConverter
    extends ParquetColumnReaders.LongColumnReader {
        TimestampBinaryConverter(DataType dataType, int n) {
            super(TimestampConverters.validTimestampType(dataType), n);
        }

        private long binaryToSQLTimestamp(Binary binary) {
            Preconditions.checkArgument((binary.length() == 12 ? 1 : 0) != 0, (String)"Timestamps (with nanoseconds) are expected to be stored in 12-byte long binaries. Found a %s-byte binary instead.", (Object[])new Object[]{binary.length()});
            ByteBuffer byteBuffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong();
            int n = byteBuffer.getInt();
            return DefaultKernelUtils.fromJulianDay(n, l);
        }

        public void addBinary(Binary binary) {
            long l;
            long l2 = l = this.binaryToSQLTimestamp(binary);
            super.addLong(l2);
        }

        @Override
        public void addLong(long l) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    public static class TimestampMillisConverter
    extends ParquetColumnReaders.LongColumnReader {
        TimestampMillisConverter(DataType dataType, int n) {
            super(TimestampConverters.validTimestampType(dataType), n);
        }

        @Override
        public void addLong(long l) {
            super.addLong(DefaultKernelUtils.millisToMicros(l));
        }
    }
}

