/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

@Evolving
public class TableIdentifier {
    private final String[] namespace;
    private final String name;

    public TableIdentifier(String[] stringArray, String string) {
        Preconditions.checkArgument(stringArray != null && stringArray.length > 0, "namespace cannot be null or empty");
        this.namespace = stringArray;
        this.name = Objects.requireNonNull(string, "name is null");
    }

    public String[] getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TableIdentifier tableIdentifier = (TableIdentifier)object;
        return Arrays.equals(this.getNamespace(), tableIdentifier.getNamespace()) && this.getName().equals(tableIdentifier.getName());
    }

    public int hashCode() {
        return 31 * Objects.hash(this.getName()) + Arrays.hashCode(this.getNamespace());
    }

    public String toString() {
        String string = Arrays.stream(this.namespace).map(this::quoteIdentifier).collect(Collectors.joining("."));
        return "TableIdentifier{" + string + "." + this.quoteIdentifier(this.name) + "}";
    }

    private String quoteIdentifier(String string) {
        return string.replace("`", "``");
    }
}

