/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.data;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.ColumnarBatchRow;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.util.NoSuchElementException;

@Evolving
public interface ColumnarBatch {
    public StructType getSchema();

    public ColumnVector getColumnVector(int var1);

    public int getSize();

    default public ColumnarBatch withNewColumn(int n, StructField structField, ColumnVector columnVector) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public ColumnarBatch withDeletedColumnAt(int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public ColumnarBatch withNewSchema(StructType structType) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    default public CloseableIterator<Row> getRows() {
        final ColumnarBatch columnarBatch = this;
        return new CloseableIterator<Row>(){
            int rowId = 0;
            int maxRowId = ColumnarBatch.this.getSize();

            @Override
            public boolean hasNext() {
                return this.rowId < this.maxRowId;
            }

            @Override
            public Row next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ColumnarBatchRow columnarBatchRow = new ColumnarBatchRow(columnarBatch, this.rowId);
                ++this.rowId;
                return columnarBatchRow;
            }

            @Override
            public void close() {
            }
        };
    }
}

