/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.exceptions.ConcurrentTransactionException;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.exceptions.InvalidConfigurationValueException;
import io.delta.kernel.exceptions.KernelEngineException;
import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.exceptions.MetadataChangedException;
import io.delta.kernel.exceptions.ProtocolChangedException;
import io.delta.kernel.exceptions.TableAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.exceptions.UnknownConfigurationException;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.DataFileStatus;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class DeltaErrors {
    private DeltaErrors() {
    }

    public static KernelException versionBeforeFirstAvailableCommit(String string, long l, long l2) {
        String string2 = String.format("%s: Cannot load table version %s as the transaction log has been truncated due to manual deletion or the log/checkpoint retention policy. The earliest available version is %s.", string, l, l2);
        return new KernelException(string2);
    }

    public static KernelException versionAfterLatestCommit(String string, long l, long l2) {
        String string2 = String.format("%s: Cannot load table version %s as it does not exist. The latest available version is %s.", string, l, l2);
        return new KernelException(string2);
    }

    public static KernelException timestampBeforeFirstAvailableCommit(String string, long l, long l2, long l3) {
        String string2 = String.format("%s: The provided timestamp %s ms (%s) is before the earliest available version %s. Please use a timestamp greater than or equal to %s ms (%s).", string, l, DeltaErrors.formatTimestamp(l), l3, l2, DeltaErrors.formatTimestamp(l2));
        return new KernelException(string2);
    }

    public static KernelException timestampAfterLatestCommit(String string, long l, long l2, long l3) {
        String string2 = String.format("%s: The provided timestamp %s ms (%s) is after the latest available version %s. Please use a timestamp less than or equal to %s ms (%s).", string, l, DeltaErrors.formatTimestamp(l), l3, l2, DeltaErrors.formatTimestamp(l2));
        return new KernelException(string2);
    }

    public static KernelException noCommitFilesFoundForVersionRange(String string, long l, long l2) {
        String string2 = String.format("%s: Requested table changes between [%s, %s] but no log files found in the requested version range.", string, l, l2);
        return new KernelException(string2);
    }

    public static KernelException startVersionNotFound(String string, long l, Optional<Long> optional) {
        String string2 = String.format("%s: Requested table changes beginning with startVersion=%s but no log file found for version %s.", string, l, l);
        if (optional.isPresent()) {
            string2 = string2 + String.format(" Earliest available version is %s", optional.get());
        }
        return new KernelException(string2);
    }

    public static KernelException endVersionNotFound(String string, long l2, Optional<Long> optional) {
        String string2 = String.format("%s: Requested table changes ending with endVersion=%d but no log file found for version %d%s", string, l2, l2, optional.map(l -> String.format(". Latest available version is %d", l)).orElse(""));
        return new KernelException(string2);
    }

    public static KernelException invalidVersionRange(long l, long l2) {
        String string = String.format("Invalid version range: requested table changes for version range [%s, %s]. Requires startVersion >= 0 and endVersion >= startVersion.", l, l2);
        return new KernelException(string);
    }

    public static KernelException unsupportedReaderProtocol(String string, int n) {
        String string2 = String.format("Unsupported Delta protocol reader version: table `%s` requires reader version %s which is unsupported by this version of Delta Kernel.", string, n);
        return new KernelException(string2);
    }

    public static KernelException unsupportedReaderFeature(String string, Set<String> set) {
        String string2 = String.format("Unsupported Delta reader features: table `%s` requires reader table features [%s] which is unsupported by this version of Delta Kernel.", string, String.join((CharSequence)", ", set));
        return new KernelException(string2);
    }

    public static KernelException unsupportedWriterProtocol(String string, int n) {
        String string2 = String.format("Unsupported Delta protocol writer version: table `%s` requires writer version %s which is unsupported by this version of Delta Kernel.", string, n);
        return new KernelException(string2);
    }

    public static KernelException unsupportedWriterFeature(String string, String string2) {
        String string3 = String.format("Unsupported Delta writer feature: table `%s` requires writer table feature \"%s\" which is unsupported by this version of Delta Kernel.", string, string2);
        return new KernelException(string3);
    }

    public static KernelException columnInvariantsNotSupported() {
        String string = "This version of Delta Kernel does not support writing to tables with column invariants present.";
        return new KernelException(string);
    }

    public static KernelException unsupportedDataType(DataType dataType) {
        return new KernelException("Kernel doesn't support writing data of type: " + dataType);
    }

    public static KernelException unsupportedPartitionDataType(String string, DataType dataType) {
        String string2 = "Kernel doesn't support writing data with partition column (%s) of type: %s";
        return new KernelException(String.format(string2, string, dataType));
    }

    public static KernelException duplicateColumnsInSchema(StructType structType, List<String> list) {
        String string = String.format("Schema contains duplicate columns: %s.\nSchema: %s", String.join((CharSequence)", ", list), structType);
        return new KernelException(string);
    }

    public static KernelException invalidColumnName(String string, String string2) {
        return new KernelException(String.format("Column name '%s' contains one of the unsupported (%s) characters.", string, string2));
    }

    public static KernelException requiresSchemaForNewTable(String string) {
        return new TableNotFoundException(string, "Must provide a new schema to write to a new table.");
    }

    public static KernelException tableAlreadyExists(String string, String string2) {
        return new TableAlreadyExistsException(string, string2);
    }

    public static KernelException dataSchemaMismatch(String string, StructType structType, StructType structType2) {
        String string2 = "The schema of the data to be written to the table doesn't match the table schema. \nTable: %s\nTable schema: %s, \nData schema: %s";
        return new KernelException(String.format(string2, string, structType, structType2));
    }

    public static KernelException missingNumRecordsStatsForIcebergCompatV2(DataFileStatus dataFileStatus) {
        throw new KernelException(String.format("Iceberg V2 compatibility requires statistics.\n DataFileStatus: %s", dataFileStatus));
    }

    public static KernelException partitionColumnMissingInData(String string, String string2) {
        String string3 = "Missing partition column '%s' in the data to be written to the table '%s'.";
        return new KernelException(String.format(string3, string2, string));
    }

    public static KernelException concurrentTransaction(String string, long l, long l2) {
        return new ConcurrentTransactionException(string, l, l2);
    }

    public static KernelException metadataChangedException() {
        return new MetadataChangedException();
    }

    public static KernelException protocolChangedException(long l) {
        return new ProtocolChangedException(l);
    }

    public static KernelException voidTypeEncountered() {
        return new KernelException("Failed to parse the schema. Encountered unsupported Delta data type: VOID");
    }

    public static KernelException cannotModifyTableProperty(String string) {
        String string2 = String.format("The Delta table property '%s' is an internal property and cannot be updated.", string);
        return new KernelException(string2);
    }

    public static KernelException unknownConfigurationException(String string) {
        return new UnknownConfigurationException(string);
    }

    public static KernelException invalidConfigurationValueException(String string, String string2, String string3) {
        return new InvalidConfigurationValueException(string, string2, string3);
    }

    public static KernelException domainMetadataUnsupported() {
        String string = "Cannot commit DomainMetadata action(s) because the feature 'domainMetadata' is not supported on this table.";
        return new KernelException(string);
    }

    public static ConcurrentWriteException concurrentDomainMetadataAction(DomainMetadata domainMetadata, DomainMetadata domainMetadata2) {
        String string = String.format("A concurrent writer added a domainMetadata action for the same domain: %s. No domain-specific conflict resolution is available for this domain. Attempted domainMetadata: %s. Winning domainMetadata: %s", domainMetadata.getDomain(), domainMetadata, domainMetadata2);
        return new ConcurrentWriteException(string);
    }

    private static String formatTimestamp(long l) {
        return new Timestamp(l).toInstant().toString();
    }

    public static <T> T wrapEngineException(Supplier<T> supplier, String string, Object ... objectArray) {
        try {
            return supplier.get();
        }
        catch (KernelException kernelException) {
            throw kernelException;
        }
        catch (RuntimeException runtimeException) {
            throw new KernelEngineException(String.format(string, objectArray), runtimeException);
        }
    }

    public static <T> T wrapEngineExceptionThrowsIO(SupplierWithIOException<T> supplierWithIOException, String string, Object ... objectArray) throws IOException {
        try {
            return supplierWithIOException.get();
        }
        catch (KernelException kernelException) {
            throw kernelException;
        }
        catch (RuntimeException runtimeException) {
            throw new KernelEngineException(String.format(string, objectArray), runtimeException);
        }
    }

    public static interface SupplierWithIOException<T> {
        public T get() throws IOException;
    }
}

