/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CheckpointInstance
implements Comparable<CheckpointInstance> {
    public static final CheckpointInstance MAX_VALUE = new CheckpointInstance(Long.MAX_VALUE);
    public final long version;
    public final Optional<Integer> numParts;
    public final CheckpointFormat format;
    public final Optional<Path> filePath;

    public CheckpointInstance(String string) {
        Preconditions.checkArgument(FileNames.isCheckpointFile(string), "not a valid checkpoint file name");
        String[] stringArray = this.getPathName(string).split("\\.");
        if (stringArray.length == 3 && stringArray[2].equals("parquet")) {
            this.version = Long.parseLong(stringArray[0]);
            this.numParts = Optional.empty();
            this.format = CheckpointFormat.CLASSIC;
            this.filePath = Optional.empty();
        } else if (stringArray.length == 5 && stringArray[4].equals("parquet")) {
            this.version = Long.parseLong(stringArray[0]);
            this.numParts = Optional.of(Integer.parseInt(stringArray[3]));
            this.format = CheckpointFormat.MULTI_PART;
            this.filePath = Optional.empty();
        } else if (stringArray.length == 4 && (stringArray[3].equals("parquet") || stringArray[3].equals("json"))) {
            this.version = Long.parseLong(stringArray[0]);
            this.numParts = Optional.empty();
            this.format = CheckpointFormat.V2;
            this.filePath = Optional.of(new Path(string));
        } else {
            throw new RuntimeException("Unrecognized checkpoint path format: " + this.getPathName(string));
        }
    }

    public CheckpointInstance(long l) {
        this(l, Optional.empty());
    }

    public CheckpointInstance(long l, Optional<Integer> optional) {
        this.version = l;
        this.numParts = optional;
        this.filePath = Optional.empty();
        this.format = optional.orElse(0) == 0 ? CheckpointFormat.CLASSIC : CheckpointFormat.MULTI_PART;
    }

    boolean isNotLaterThan(CheckpointInstance checkpointInstance) {
        if (checkpointInstance == MAX_VALUE) {
            return true;
        }
        return this.version <= checkpointInstance.version;
    }

    boolean isEarlierThan(CheckpointInstance checkpointInstance) {
        if (checkpointInstance == MAX_VALUE) {
            return true;
        }
        return this.version < checkpointInstance.version;
    }

    public List<Path> getCorrespondingFiles(Path path) {
        if (this == MAX_VALUE) {
            throw new IllegalStateException("Can't get files for CheckpointVersion.MaxValue.");
        }
        if (this.format == CheckpointFormat.V2) {
            return Collections.singletonList(this.filePath.get());
        }
        return this.numParts.map(n -> FileNames.checkpointFileWithParts(path, this.version, n)).orElseGet(() -> Collections.singletonList(FileNames.checkpointFileSingular(path, this.version)));
    }

    @Override
    public int compareTo(CheckpointInstance checkpointInstance) {
        if (this.version != checkpointInstance.version) {
            return Long.compare(this.version, checkpointInstance.version);
        }
        if (this.format != checkpointInstance.format) {
            return Integer.compare(this.format.ordinal(), checkpointInstance.format.ordinal());
        }
        switch (this.format) {
            case CLASSIC: {
                return 0;
            }
            case MULTI_PART: {
                return Long.compare(this.numParts.orElse(1).intValue(), checkpointInstance.numParts.orElse(1).intValue());
            }
            case V2: {
                return this.filePath.get().getName().compareTo(checkpointInstance.filePath.get().getName());
            }
        }
        throw new IllegalStateException("Unexpected format: " + (Object)((Object)this.format));
    }

    public String toString() {
        return "CheckpointInstance{version=" + this.version + ", numParts=" + this.numParts + ", format=" + (Object)((Object)this.format) + ", filePath=" + this.filePath + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CheckpointInstance checkpointInstance = (CheckpointInstance)object;
        return this.compareTo(checkpointInstance) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.numParts, this.format, this.filePath});
    }

    private String getPathName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(n + 1);
    }

    public static enum CheckpointFormat {
        CLASSIC,
        MULTI_PART,
        V2;


        public boolean usesSidecars() {
            return this == CLASSIC || this == V2;
        }
    }
}

