/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.FileStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class LogReplayUtils {
    private LogReplayUtils() {
    }

    public static UniqueFileActionTuple getUniqueFileAction(ColumnVector columnVector, ColumnVector columnVector2, int n) {
        String string = columnVector.getString(n);
        URI uRI = LogReplayUtils.pathToUri(string);
        Optional<String> optional = Optional.ofNullable(DeletionVectorDescriptor.fromColumnVector(columnVector2, n)).map(DeletionVectorDescriptor::getUniqueId);
        return new UniqueFileActionTuple(uRI, optional);
    }

    public static void assertLogFilesBelongToTable(Path path, List<FileStatus> list) {
        String string = path.toString();
        for (FileStatus fileStatus : list) {
            String string2 = fileStatus.getPath();
            if (string2.startsWith(string)) continue;
            throw new RuntimeException("File (" + string2 + ") doesn't belong in the transaction log at " + string + ".");
        }
    }

    static boolean[] prepareSelectionVectorBuffer(boolean[] blArray, int n) {
        if (blArray == null || blArray.length < n) {
            blArray = new boolean[n];
        } else {
            Arrays.fill(blArray, false);
        }
        return blArray;
    }

    static URI pathToUri(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    static int[] getPathOrdinals(StructType structType, String ... stringArray) {
        Preconditions.checkArgument(stringArray.length > 0, "Invalid path");
        int[] nArray = new int[stringArray.length];
        DataType dataType = structType;
        for (int i = 0; i < stringArray.length; ++i) {
            Preconditions.checkArgument(dataType instanceof StructType, "Invalid search path");
            StructType structType2 = dataType;
            nArray[i] = structType2.indexOf(stringArray[i]);
            dataType = structType2.at(nArray[i]).getDataType();
        }
        return nArray;
    }

    static ColumnVector getVector(ColumnarBatch columnarBatch, int[] nArray) {
        Preconditions.checkArgument(nArray.length > 0, "Invalid path ordinals size");
        ColumnVector columnVector = null;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            columnVector = i == 0 ? columnarBatch.getColumnVector(n) : columnVector.getChild(n);
        }
        return columnVector;
    }

    public static class UniqueFileActionTuple
    extends Tuple2<URI, Optional<String>> {
        UniqueFileActionTuple(URI uRI, Optional<String> optional) {
            super(uRI, optional);
        }
    }
}

