/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.compat;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.compat.SerializeKafkaAvro;
import com.dataiku.dip.spark.compat.StructuredStreamingStreamingEndpointWriter$;
import com.dataiku.dip.streaming.endpoints.kafka.AvroKafkaFormat;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatSerializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointMeta;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.kafka.SingleValueKafkaFormat;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class StructuredStreamingStreamingEndpointWriter$ {
    public static StructuredStreamingStreamingEndpointWriter$ MODULE$;
    private final Logger logger;

    static {
        new StructuredStreamingStreamingEndpointWriter$();
    }

    public Column buildSerializedColumn(String formatType, JsonObject formatParams, Dataset<Row> df, Schema schema, String topic, Map<String, String> kafkaOptions, boolean isKey) {
        String string = formatType;
        if ("json".equals(string)) {
            KafkaFormatSerializer serializer = KafkaFormatsFactory.getSerializer((String)formatType, (JsonObject)formatParams);
            Buffer columns = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(serializer.columnNamesForSchema(schema)).asScala();
            return functions$.MODULE$.to_json(functions$.MODULE$.struct((Seq)columns.toSeq().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom())), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestampNTZFormat"), (Object)"yyyy-MM-dd HH:mm:ss.SSS")})));
        }
        if ("avro".equals(string)) {
            AvroKafkaFormat.AvroKafkaFormatParams parsedFormatParams = (AvroKafkaFormat.AvroKafkaFormatParams)JSON.parse((JsonElement)formatParams, AvroKafkaFormat.AvroKafkaFormatParams.class);
            String avroSchemaJson = parsedFormatParams.getAvroSchema(schema).toString(true);
            KafkaFormatSerializer serializer = KafkaFormatsFactory.getSerializer((String)formatType, (JsonObject)formatParams);
            Buffer columns = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(serializer.columnNamesForSchema(schema)).asScala();
            StructType subType = StructType$.MODULE$.apply((Seq)df.schema().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)columns.contains((Object)f.name()))));
            UserDefinedFunction to_kafka_avro = functions$.MODULE$.udf((UDF1)new SerializeKafkaAvro(avroSchemaJson, kafkaOptions, isKey, subType, topic), (DataType)BinaryType$.MODULE$);
            return to_kafka_avro.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)columns.toSeq().map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom()))}));
        }
        if ("single".equals(string)) {
            SingleValueKafkaFormat.SingleValueKafkaFormatParams typedParams = (SingleValueKafkaFormat.SingleValueKafkaFormatParams)JSON.parse((JsonElement)formatParams, SingleValueKafkaFormat.SingleValueKafkaFormatParams.class);
            if (StringUtils.isBlank((String)typedParams.columnName)) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator1$1() {
                    }
                }
                return functions$.MODULE$.typedLit(null, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator1$1()));
            }
            Column untyped = functions$.MODULE$.col(typedParams.columnName);
            SingleValueKafkaFormat.KeyType keyType = typedParams.columnType;
            if (SingleValueKafkaFormat.KeyType.STRING.equals(keyType)) {
                return untyped.cast((DataType)StringType$.MODULE$);
            }
            if (SingleValueKafkaFormat.KeyType.LONG.equals(keyType)) {
                Function1 & Serializable & scala.Serializable ser = (Function1 & Serializable & scala.Serializable)x -> StructuredStreamingStreamingEndpointWriter$.$anonfun$buildSerializedColumn$4(BoxesRunTime.unboxToLong((Object)x));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator2$1() {
                    }
                }
                UserDefinedFunction serUDF = functions$.MODULE$.udf((Function1)ser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
                return serUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{untyped.cast((DataType)LongType$.MODULE$)}));
            }
            if (SingleValueKafkaFormat.KeyType.INTEGER.equals(keyType)) {
                Function1 & Serializable & scala.Serializable ser = (Function1 & Serializable & scala.Serializable)x -> Ints.toByteArray((int)Predef$.MODULE$.Integer2int(x));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator3$1() {
                    }
                }
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("java.lang.Integer").asType().toTypeConstructor();
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator4$1() {
                    }
                }
                UserDefinedFunction serUDF = functions$.MODULE$.udf((Function1)ser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator3$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator4$1()));
                return serUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{untyped.cast((DataType)IntegerType$.MODULE$)}));
            }
            if (SingleValueKafkaFormat.KeyType.DOUBLE.equals(keyType)) {
                Function1 & Serializable & scala.Serializable ser = (Function1 & Serializable & scala.Serializable)x -> StructuredStreamingStreamingEndpointWriter$.$anonfun$buildSerializedColumn$6(BoxesRunTime.unboxToDouble((Object)x));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator5$1() {
                    }
                }
                UserDefinedFunction serUDF = functions$.MODULE$.udf((Function1)ser, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_dataiku_dip_spark_compat_StructuredStreamingStreamingEndpointWriter$$typecreator5$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                return serUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{untyped.cast((DataType)DoubleType$.MODULE$)}));
            }
            if (SingleValueKafkaFormat.KeyType.BYTEARRAY.equals(keyType)) {
                return untyped.cast((DataType)BinaryType$.MODULE$);
            }
            throw new MatchError((Object)keyType);
        }
        throw new UnsupportedOperationException(new StringBuilder(25).append("Cannot convert to ").append(formatType).append(" format").toString());
    }

    public StreamingQuery saveStreaming(StreamingEndpoint se, Dataset<Row> df, String outputMode, String apiTicket, boolean useRaw) {
        String string = se.getType();
        if ("kafka".equals(string)) {
            Dataset dataset;
            KafkaStreamingEndpointParams params = (KafkaStreamingEndpointParams)new KafkaStreamingEndpointMeta().getExpandedParams(com.dataiku.dip.remoterun.package$.MODULE$.getProjectFromEnv(), se, KafkaStreamingEndpointParams.class);
            DSSConnection rawConn = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getConnection((AuthCtx)DSSAuthCtx.newNone(), params.connection);
            if (rawConn == null) {
                throw new Exception("Kafka connection details are not available in Spark driver: do you need to authorize it?");
            }
            KafkaConnection conn = (KafkaConnection)rawConn;
            Properties props = conn.buildBasicProperties((AuthCtx)DSSAuthCtx.newNone(), null);
            String string2 = "group.id";
            String string3 = "auto.offset.reset";
            String string4 = "enable.auto.commit";
            String string5 = "interceptor.classes";
            String string6 = "key.deserializer";
            String string7 = "key.serializer";
            String string8 = "value.deserializer";
            String string9 = "value.serializer";
            List excludedProperties = Nil$.MODULE$.$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2);
            scala.collection.mutable.Map rawOptions = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)StructuredStreamingStreamingEndpointWriter$.$anonfun$saveStreaming$1(excludedProperties, kv)));
            scala.collection.mutable.Map options = (scala.collection.mutable.Map)rawOptions.map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(6).append("kafka.").append(kv._1()).toString()), kv._2()), Map$.MODULE$.canBuildFrom());
            if (useRaw) {
                this.logger().info((Object)"Write dataframe as-is, using key and value columns");
                dataset = df;
            } else {
                this.logger().info((Object)"Apply endpoint format to build up key and value columns");
                Dataset keyValueDf = df.withColumn("key", this.buildSerializedColumn(params.keyFormatType, params.keyFormatParams, df, se.schema, params.topic, (Map<String, String>)rawOptions.toMap(Predef$.MODULE$.$conforms()), true)).withColumn("value", this.buildSerializedColumn(params.formatType, params.formatParams, df, se.schema, params.topic, (Map<String, String>)rawOptions.toMap(Predef$.MODULE$.$conforms()), false));
                dataset = params.producerParams.provideTimestamp && StringUtils.isNotBlank((String)params.timestampColumn) ? keyValueDf.withColumn("timestamp", df.col(params.timestampColumn)) : keyValueDf;
            }
            Dataset dfWithKeyValue = dataset;
            DataStreamWriter dswBuilder = dfWithKeyValue.writeStream().format("kafka").option("topic", params.topic).outputMode(outputMode);
            DataStreamWriter dsw = (DataStreamWriter)options.foldLeft((Object)dswBuilder, (Function2 & Serializable & scala.Serializable)(b, option) -> b.option((String)option._1(), (String)option._2()));
            return dsw.start();
        }
        throw new UnsupportedOperationException("Output not supported in structured streaming");
    }

    public boolean saveStreaming$default$5() {
        return false;
    }

    private Logger logger() {
        return this.logger;
    }

    public static final /* synthetic */ byte[] $anonfun$buildSerializedColumn$4(long x) {
        return Longs.toByteArray((long)x);
    }

    public static final /* synthetic */ byte[] $anonfun$buildSerializedColumn$6(double x) {
        return Longs.toByteArray((long)Double.doubleToLongBits(x));
    }

    public static final /* synthetic */ boolean $anonfun$saveStreaming$1(List excludedProperties$1, Tuple2 kv) {
        return !excludedProperties$1.contains(kv._1());
    }

    private StructuredStreamingStreamingEndpointWriter$() {
        MODULE$ = this;
        this.logger = Logger.getLogger((String)"dku.spark.streaming.writer");
    }
}

