/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;
import org.apache.hadoop.yarn.api.records.NodeToAttributeValue;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeAttributeKeyPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeToAttributeValuePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetAttributesToNodesResponsePBImpl
extends GetAttributesToNodesResponse {
    private YarnServiceProtos.GetAttributesToNodesResponseProto proto = YarnServiceProtos.GetAttributesToNodesResponseProto.getDefaultInstance();
    private YarnServiceProtos.GetAttributesToNodesResponseProto.Builder builder = null;
    private boolean viaProto = false;
    private Map<NodeAttributeKey, List<NodeToAttributeValue>> attributesToNodes;

    public GetAttributesToNodesResponsePBImpl() {
        this.builder = YarnServiceProtos.GetAttributesToNodesResponseProto.newBuilder();
    }

    public GetAttributesToNodesResponsePBImpl(YarnServiceProtos.GetAttributesToNodesResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    private void initAttributesToNodes() {
        if (this.attributesToNodes != null) {
            return;
        }
        YarnServiceProtos.GetAttributesToNodesResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.AttributeToNodesProto> list = p.getAttributesToNodesList();
        this.attributesToNodes = new HashMap<NodeAttributeKey, List<NodeToAttributeValue>>();
        for (YarnProtos.AttributeToNodesProto c : list) {
            List<YarnProtos.NodeToAttributeValueProto> nodeValueMapList = c.getNodeValueMapList();
            ArrayList<NodeToAttributeValue> nodeToAttributeValue = new ArrayList<NodeToAttributeValue>();
            for (YarnProtos.NodeToAttributeValueProto valueProto : nodeValueMapList) {
                nodeToAttributeValue.add(this.convertFromProtoFormat(valueProto));
            }
            if (nodeToAttributeValue.isEmpty()) continue;
            this.attributesToNodes.put(this.convertFromProtoFormat(c.getNodeAttribute()), nodeToAttributeValue);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetAttributesToNodesResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void addAttributesToNodesToProto() {
        this.maybeInitBuilder();
        this.builder.clearAttributesToNodes();
        if (this.attributesToNodes == null) {
            return;
        }
        Iterable iterable = () -> new Iterator<YarnProtos.AttributeToNodesProto>(){
            private Iterator iter;
            {
                this.iter = GetAttributesToNodesResponsePBImpl.this.attributesToNodes.entrySet().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public YarnProtos.AttributeToNodesProto next() {
                Map.Entry attrToNodes = (Map.Entry)this.iter.next();
                YarnProtos.AttributeToNodesProto.Builder attrToNodesBuilder = YarnProtos.AttributeToNodesProto.newBuilder().setNodeAttribute(GetAttributesToNodesResponsePBImpl.this.convertToProtoFormat((NodeAttributeKey)attrToNodes.getKey()));
                for (NodeToAttributeValue hostToAttrVal : (List)attrToNodes.getValue()) {
                    attrToNodesBuilder.addNodeValueMap(GetAttributesToNodesResponsePBImpl.this.convertToProtoFormat(hostToAttrVal));
                }
                return attrToNodesBuilder.build();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }
        };
        this.builder.addAllAttributesToNodes(iterable);
    }

    private NodeAttributeKey convertFromProtoFormat(YarnProtos.NodeAttributeKeyProto p) {
        return new NodeAttributeKeyPBImpl(p);
    }

    private YarnProtos.NodeAttributeKeyProto convertToProtoFormat(NodeAttributeKey t) {
        return ((NodeAttributeKeyPBImpl)t).getProto();
    }

    private NodeToAttributeValue convertFromProtoFormat(YarnProtos.NodeToAttributeValueProto p) {
        return new NodeToAttributeValuePBImpl(p);
    }

    private YarnProtos.NodeToAttributeValueProto convertToProtoFormat(NodeToAttributeValue t) {
        return ((NodeToAttributeValuePBImpl)t).getProto();
    }

    private void mergeLocalToBuilder() {
        if (this.attributesToNodes != null) {
            this.addAttributesToNodesToProto();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    public YarnServiceProtos.GetAttributesToNodesResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((GetAttributesToNodesResponsePBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public void setAttributeToNodes(Map<NodeAttributeKey, List<NodeToAttributeValue>> map) {
        this.initAttributesToNodes();
        this.attributesToNodes.clear();
        this.attributesToNodes.putAll(map);
    }

    @Override
    public Map<NodeAttributeKey, List<NodeToAttributeValue>> getAttributesToNodes() {
        this.initAttributesToNodes();
        return this.attributesToNodes;
    }
}

