/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.logging;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.logging.LimitedLogFactory;
import com.dataiku.dip.logging.MainLoggingConfiguratorBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.LogManager;
import org.apache.log4j.Logger;

public class MainLoggingConfigurator
extends MainLoggingConfiguratorBase {
    public static void configure(ProcessType p) {
        MainLoggingConfigurator.loadMainLog4JProperties();
        Logger logger = Logger.getLogger((String)"dku.logging");
        logger.info((Object)"Loading logging settings");
        MainLoggingConfigurator.loadFile((File)DKUApp.getResourceFile("logging", "dku-log4j.properties"));
        MainLoggingConfigurator.loadFile((File)DKUApp.getUserResourceFile("logging", "dku-log4j.properties"));
        MainLoggingConfigurator.loadFile((File)DKUApp.getResourceFile("logging", "dku-" + p.toString().toLowerCase() + "-log4j.properties"));
        MainLoggingConfigurator.loadFile((File)DKUApp.getUserResourceFile("logging", "dku-" + p.toString().toLowerCase() + "-log4j.properties"));
        try {
            InputStream julConfig = MainLoggingConfigurator.class.getClassLoader().getResourceAsStream("log-jul.properties");
            if (julConfig != null) {
                LogManager.getLogManager().readConfiguration(julConfig);
            }
            MainLoggingConfigurator.loadJULFile((File)DKUApp.getResourceFile("logging", "dku-log-jul.properties"));
            MainLoggingConfigurator.loadJULFile((File)DKUApp.getUserResourceFile("logging", "dku-log-jul.properties"));
            MainLoggingConfigurator.loadJULFile((File)DKUApp.getResourceFile("logging", "dku-" + p.toString().toLowerCase() + "-log-jul.properties"));
            MainLoggingConfigurator.loadJULFile((File)DKUApp.getUserResourceFile("logging", "dku-" + p.toString().toLowerCase() + "-log-jul.properties"));
        }
        catch (Exception e) {
            logger.warn((Object)"failed to configure JUL logging", (Throwable)e);
        }
    }

    public static void configureLimits() {
        try {
            File f = DKUApp.getFile("config/dip.properties");
            if (!f.exists()) {
                throw new FileNotFoundException("config/dip.properties not found");
            }
            Properties config = new Properties();
            FileInputStream fis = new FileInputStream(f);
            config.load(fis);
            fis.close();
            LimitedLogFactory.configure((Properties)config);
        }
        catch (Throwable e) {
            Logger.getLogger((String)"dku.logging").warn((Object)"Cannot load dip.properties for log clipping", e);
        }
    }

    public static enum ProcessType {
        BACKEND,
        JEK,
        FEK,
        CAK,
        DKU,
        EVENTSERVER,
        APIMAIN,
        FM,
        GOVERN,
        CDE,
        UNKNOWN;

    }
}

