/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.maintainance.UnloggedJob;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ClassUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public abstract class DkuScheduledTasksService {
    private Queue<LogEntry> logEntries = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)30));
    Scheduler scheduler;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.scheduler.backgroundtasks");

    protected abstract String describe(String var1, String var2);

    public void fireNow(String jobGroup, String jobName) throws SchedulerException {
        JobKey jobKey = new JobKey(jobName, jobGroup);
        this.scheduler.triggerJob(jobKey);
    }

    public SchedulerState getSchedulerState() throws SchedulerException {
        SchedulerState ret = new SchedulerState();
        for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.anyJobGroup())) {
            List triggers = this.scheduler.getTriggersOfJob(jobKey);
            JobDetail jd = this.scheduler.getJobDetail(jobKey);
            ScheduledTask st = new ScheduledTask();
            st.jobName = jobKey.getName();
            st.jobGroup = jobKey.getGroup();
            boolean bl = st.logged = !ClassUtils.isAssignable((Class)jd.getJobClass(), UnloggedJob.class);
            if (triggers.size() == 1) {
                Trigger t = (Trigger)triggers.get(0);
                st.lastFire = t.getPreviousFireTime() == null ? null : DKUDateUtils.isoFormatLocal((long)t.getPreviousFireTime().getTime());
                st.nextFire = t.getNextFireTime() == null ? null : DKUDateUtils.isoFormatLocal((long)t.getNextFireTime().getTime());
            }
            st.description = this.describe(st.jobGroup, st.jobName);
            ret.tasks.add(st);
        }
        ret.log = new ArrayList<LogEntry>(this.logEntries);
        return ret;
    }

    protected void addCron(Class<? extends Job> clazz, String group, String name, String cronExpr) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(clazz).withIdentity(name, group).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name + "-cron-trigger", group).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpr)).build();
        this.scheduler.scheduleJob(job, trigger);
    }

    protected abstract void initScheduledTasks() throws IOException, SchedulerException;

    @PostConstruct
    public void init() throws SchedulerException, IOException {
        logger.debug((Object)"Init scheduled tasks service");
        if (FeatureFlags.isEnabled("LEAN_BOOT")) {
            logger.info((Object)"Lean boot mode enabled, no scheduler");
            return;
        }
        this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        this.scheduler.start();
        this.scheduler.getListenerManager().addJobListener((JobListener)new JobLogger(), (Matcher)GroupMatcher.anyJobGroup());
        this.initScheduledTasks();
        logger.debug((Object)"Done init scheduled tasks service");
    }

    @UIModel
    public static class SchedulerState {
        List<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
        Collection<LogEntry> log;
    }

    public static class ScheduledTask {
        public String jobGroup;
        public String jobName;
        public String description;
        public boolean logged;
        @Nullable
        public String lastFire;
        @Nullable
        public String nextFire;
    }

    private class JobLogger
    implements JobListener {
        private JobLogger() {
        }

        public String getName() {
            return "job logger";
        }

        public void jobToBeExecuted(JobExecutionContext context) {
            JobDetail jd = context.getJobDetail();
            if (ClassUtils.isAssignable((Class)jd.getJobClass(), UnloggedJob.class)) {
                return;
            }
            LogEntry le = new LogEntry(jd);
            le.description = "Job about to start";
            DkuScheduledTasksService.this.logEntries.add(le);
        }

        public void jobExecutionVetoed(JobExecutionContext context) {
            JobDetail jd = context.getJobDetail();
            if (ClassUtils.isAssignable((Class)jd.getJobClass(), UnloggedJob.class)) {
                return;
            }
            LogEntry le = new LogEntry(jd);
            le.description = "Job start vetoed";
            DkuScheduledTasksService.this.logEntries.add(le);
        }

        public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
            JobDetail jd = context.getJobDetail();
            if (ClassUtils.isAssignable((Class)jd.getJobClass(), UnloggedJob.class)) {
                return;
            }
            LogEntry le = new LogEntry(jd);
            le.description = jobException == null ? "Job executed (t=" + context.getJobRunTime() + "ms)" : "Job failed: " + ExceptionUtils.getMessageWithCauses((Throwable)jobException);
            DkuScheduledTasksService.this.logEntries.add(le);
        }
    }

    public static class LogEntry {
        String timestamp = DKUDateUtils.isoFormatLocalNow();
        String jobGroup;
        String jobName;
        String description;

        LogEntry(JobDetail detail) {
            this.jobGroup = detail.getKey().getGroup();
            this.jobName = detail.getKey().getName();
        }
    }
}

