/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.security.FileSymmetricKeyBasedPasswordEncryptionProviderBase;
import com.dataiku.dip.security.SymetricCrypto;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigFileSymmetricKeyBasedPasswordEncryptionProvider
extends FileSymmetricKeyBasedPasswordEncryptionProviderBase {
    @Autowired
    private TransactionService transactionService;
    public static RelFile DEFAULT_CONFIG_KEY_FILE = new RelFile("configkey.json");
    private final RelFile usedConfigKeyFile;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.encryption");

    public ConfigFileSymmetricKeyBasedPasswordEncryptionProvider() {
        this.usedConfigKeyFile = DEFAULT_CONFIG_KEY_FILE;
    }

    public ConfigFileSymmetricKeyBasedPasswordEncryptionProvider(TransactionService transactionService, RelFile configKeyFile) {
        this.usedConfigKeyFile = configKeyFile;
        this.transactionService = transactionService;
    }

    public static void generateKey(RelFile targetFile) throws Exception {
        TransactionContext.assertAttachedRWTransaction();
        TransactionContext.retrieveWrite().writeObject(targetFile, ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.generateKey());
    }

    public static void generateDefaultKey() throws Exception {
        ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.generateKey(DEFAULT_CONFIG_KEY_FILE);
    }

    @Override
    protected SymetricCrypto initCrypto(String providerParams) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            logger.debug((Object)"Init crypto service");
            if (t.isFile(this.usedConfigKeyFile)) {
                KeyFile kf = t.readObjectUnsafe(this.usedConfigKeyFile, KeyFile.class);
                SymetricCrypto symetricCrypto = new SymetricCrypto(Base64.decodeBase64((String)kf.key));
                return symetricCrypto;
            }
            SymetricCrypto symetricCrypto = new SymetricCrypto(null);
            return symetricCrypto;
        }
    }

    private static class KeyFile {
        private String key;

        private KeyFile() {
        }
    }
}

