/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.SSOSettings;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.sso.SSORedirectURL;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.BaseEncoding;
import com.lastpass.saml.AttributeSet;
import com.lastpass.saml.IdPConfig;
import com.lastpass.saml.SAMLClient;
import com.lastpass.saml.SAMLException;
import com.lastpass.saml.SAMLInit;
import com.lastpass.saml.SAMLUtils;
import com.lastpass.saml.SPConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class SAMLHelper {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth.sso");
    private final SSOSettings ssoSettings;
    private final SAMLClient samlClient;
    public static final String RELAYSTATE_PARAM = "RelayState";
    private static final int RELAYSTATE_TTL_MIN = 10;
    private static final LoadingCache<String, String> relayStates = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            logger.warnV("Failed to retrieve RelayState '%s'. It may have already been used or expired after %d minutes.", new Object[]{key, 10});
            return null;
        }
    });

    public SAMLHelper(SSOSettings ssoSettings, PasswordEncryptionService cryptoService) throws SAMLException {
        this.ssoSettings = ssoSettings;
        this.samlClient = this.buildSAMLClient(ssoSettings, cryptoService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSORedirectURL getRedirectURL(MultiValueMap<String, String> extraQueryParams, String redirectTo) throws SAMLException {
        if (!this.ssoSettings.enabled || this.samlClient == null) {
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)"/login/").queryParams(extraQueryParams).build();
            return new SSORedirectURL(uriComponents.toUriString());
        }
        if (this.ssoSettings.samlSPParams.enableRelayState) {
            String relayStateUuid = UUID.randomUUID().toString();
            LoadingCache<String, String> loadingCache = relayStates;
            synchronized (loadingCache) {
                relayStates.put((Object)relayStateUuid, (Object)(StringUtils.isEmpty((String)redirectTo) ? "/" : redirectTo));
            }
            logger.infoV("Setup RelayState %s to %s", new Object[]{relayStateUuid, redirectTo});
            extraQueryParams.add((Object)RELAYSTATE_PARAM, (Object)relayStateUuid);
        }
        return new SSORedirectURL(this.getAuthnRequestRedirectURL(extraQueryParams).toString());
    }

    public SSORedirectURL getRedirectURL(String redirectTo) throws SAMLException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        return this.getRedirectURL((MultiValueMap<String, String>)params, redirectTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String consumeRelayState(String relayStateUuid) throws Exception {
        if (!this.ssoSettings.samlSPParams.enableRelayState) {
            return "/";
        }
        if (StringUtils.isEmpty((String)relayStateUuid)) {
            throw new SAMLException("RelayState is missing from the request. This likely means the SAML IdP does not support RelayState. Consider disabling RelayState support in the SAML configuration.");
        }
        String redirectTo = null;
        LoadingCache<String, String> loadingCache = relayStates;
        synchronized (loadingCache) {
            redirectTo = (String)relayStates.get((Object)relayStateUuid);
            relayStates.invalidate((Object)relayStateUuid);
        }
        if (redirectTo == null) {
            throw new SAMLException(String.format("RelayState '%s' is invalid: it may have expired after %d minutes or has already been used.", relayStateUuid, 10));
        }
        logger.infoV("Redirecting user with RelayState to %s", new Object[]{redirectTo});
        return redirectTo;
    }

    public SAMLClient getClient() {
        return this.samlClient;
    }

    public AttributeSet validateResponse(String authnResponse) throws SAMLException {
        logger.info((Object)("SAML assertion: " + authnResponse));
        return this.samlClient.validateResponse(authnResponse);
    }

    public UserIdentity getUserIdentity(AttributeSet aset) {
        UserIdentity userIdentity = new UserIdentity(UserSourceType.LOCAL_NO_AUTH, aset.getNameId());
        if (StringUtils.isNotBlank((String)this.ssoSettings.samlLoginAttribute)) {
            userIdentity.login = aset.getAttributes().getOrDefault(this.ssoSettings.samlLoginAttribute, Collections.singletonList(aset.getNameId())).get(0);
        }
        if (StringUtils.isNotBlank((String)this.ssoSettings.samlSPParams.displayNameAttribute)) {
            userIdentity.displayName = aset.getAttributes().getOrDefault(this.ssoSettings.samlSPParams.displayNameAttribute, Collections.singletonList(null)).get(0);
        }
        if (StringUtils.isNotBlank((String)this.ssoSettings.samlSPParams.emailAttribute)) {
            userIdentity.email = aset.getAttributes().getOrDefault(this.ssoSettings.samlSPParams.emailAttribute, Collections.singletonList(null)).get(0);
        }
        if (this.ssoSettings.samlSPParams.enableGroups && StringUtils.isNotBlank((String)this.ssoSettings.samlSPParams.groupsAttribute)) {
            userIdentity.groupNames = new HashSet<String>(aset.getAttributes().getOrDefault(this.ssoSettings.samlSPParams.groupsAttribute, new ArrayList()));
        }
        return userIdentity;
    }

    private SAMLClient buildSAMLClient(SSOSettings ssoSettings, PasswordEncryptionService cryptoService) throws SAMLException {
        SAMLInit.initialize();
        if (StringUtils.isEmpty((String)ssoSettings.samlIDPMetadata)) {
            throw new SAMLException("Missing SAML IdP metadata");
        }
        IdPConfig idpConfig = new IdPConfig(IOUtils.toInputStream((String)ssoSettings.samlIDPMetadata, (Charset)StandardCharsets.UTF_8));
        SSOSettings.SAMLSPParams spParams = ssoSettings.samlSPParams;
        if (spParams == null) {
            throw new SAMLException("Missing SAML SP parameters");
        }
        SPConfig spConfig = new SPConfig();
        spConfig.setEntityId(spParams.entityId);
        spConfig.setAcs(spParams.acsURL);
        try {
            if (spParams.signRequests) {
                String ksFilename = spParams.keystoreFile;
                if (StringUtils.isEmpty((String)ksFilename)) {
                    throw new SAMLException("Cannot sign SAML requests without a keystore");
                }
                char[] ksPassword = spParams.decryptKeystorePassword(cryptoService).orElse("").toCharArray();
                String ksAlias = spParams.keyAlias;
                logger.info((Object)("Opening PKCS#12 keystore: " + ksFilename));
                KeyStore keyStore = KeyStore.getInstance("pkcs12");
                try (FileInputStream ksData = new FileInputStream(ksFilename);){
                    keyStore.load(ksData, ksPassword);
                }
                if (StringUtils.isEmpty((String)ksAlias)) {
                    if (keyStore.size() == 0) {
                        throw new SAMLException("Keystore is empty: " + ksFilename);
                    }
                    if (keyStore.size() > 1) {
                        throw new SAMLException("Key alias not provided and keystore contains multiple keys: " + ksFilename);
                    }
                    ksAlias = keyStore.aliases().nextElement();
                }
                if (!keyStore.containsAlias(ksAlias)) {
                    throw new SAMLException("Entry " + ksAlias + " not found in keystore: " + ksFilename);
                }
                if (!keyStore.entryInstanceOf(ksAlias, KeyStore.PrivateKeyEntry.class)) {
                    throw new SAMLException("Keystore entry is not a private key: " + ksAlias);
                }
                spConfig.setCertificate((X509Certificate)keyStore.getCertificate(ksAlias));
                spConfig.setPrivateKey((PrivateKey)keyStore.getKey(ksAlias, ksPassword));
                String keyAlg = spConfig.getPrivateKey().getAlgorithm();
                if (!keyAlg.equals("RSA") && !keyAlg.equals("DSA")) {
                    throw new SAMLException("Unsupported key type, must be RSA or DSA: " + keyAlg);
                }
                logger.info((Object)("Loaded SAML private key, alias=" + ksAlias + " type=" + keyAlg));
            }
            return new SAMLClient(spConfig, idpConfig);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SAMLException("Unable to recover key behind alias: " + spParams.keyAlias, e);
        }
        catch (CertificateException e) {
            throw new SAMLException("Couldn't upload certificate into Keystore for SAML", e);
        }
        catch (KeyStoreException e) {
            throw new SAMLException("Failed to access keystore for SAML", e);
        }
        catch (IOException e) {
            throw new SAMLException("Unable to load SAML client", e);
        }
    }

    private void addExtraParams(URIBuilder uriBuilder, MultiValueMap<String, String> extraQueryParams) {
        if (extraQueryParams == null) {
            return;
        }
        extraQueryParams.forEach((key, values) -> values.forEach(value -> uriBuilder.addParameter(key, value)));
    }

    private URI getAuthnRequestRedirectURL(MultiValueMap<String, String> extraQueryParams) throws SAMLException {
        try {
            String requestId = SAMLUtils.generateRequestId();
            String authRequest = this.samlClient.generateAuthnRequest(requestId);
            URIBuilder uriBuilder = new URIBuilder(this.samlClient.getIdPConfig().getLoginUrl()).setCharset(StandardCharsets.UTF_8).addParameter("SAMLRequest", authRequest);
            this.addExtraParams(uriBuilder, extraQueryParams);
            PrivateKey privKey = this.samlClient.getSPConfig().getPrivateKey();
            if (privKey != null) {
                String signatureAlgorithm;
                String sigAlg = switch (signatureAlgorithm = this.ssoSettings.samlSPParams.hashingAlgorithm + "with" + privKey.getAlgorithm()) {
                    case "SHA256withRSA" -> "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                    case "SHA1withRSA" -> "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                    case "SHA256withDSA" -> "http://www.w3.org/2009/xmldsig11#dsa-sha256";
                    case "SHA1withDSA" -> "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
                    default -> throw new SAMLException("Unsupported hashing algorithm or key type, must be SHA1 or SHA256 and RSA or DSA: " + signatureAlgorithm);
                };
                logger.infoV("Signing client request with " + signatureAlgorithm, new Object[0]);
                Signature signature = Signature.getInstance(signatureAlgorithm);
                URIBuilder queryBuilder = new URIBuilder().setCharset(StandardCharsets.UTF_8).addParameter("SAMLRequest", authRequest);
                this.addExtraParams(queryBuilder, extraQueryParams);
                queryBuilder.addParameter("SigAlg", sigAlg);
                String toSign = URLEncodedUtils.format((List)queryBuilder.getQueryParams(), (String)"UTF-8");
                signature.initSign(privKey);
                signature.update(toSign.getBytes(StandardCharsets.UTF_8));
                uriBuilder.addParameter("SigAlg", sigAlg);
                uriBuilder.addParameter("Signature", BaseEncoding.base64().encode(signature.sign()));
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new SAMLException("Couldn't build SAML login URI: " + this.samlClient.getIdPConfig().getLoginUrl(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SAMLException("Couldn't build SAML signature", e);
        }
        catch (InvalidKeyException e) {
            throw new SAMLException("Couldn't initialize SAML signature", e);
        }
        catch (SignatureException e) {
            throw new SAMLException("Couldn't sign SAML request", e);
        }
    }
}

