/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server;

import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.utils.DKULogger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class SpringUtils
implements ApplicationContextAware {
    private static SpringUtils instance;
    private ApplicationContext appContext;
    static DKULogger logger;

    public static SpringUtils getInstance() {
        return instance;
    }

    public static void kill() {
        instance = null;
    }

    public SpringUtils() {
        assert (instance == null);
        instance = this;
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.appContext = arg0;
    }

    public void autowire(Object bean) {
        this.appContext.getAutowireCapableBeanFactory().autowireBean(bean);
    }

    public AutowireCapableBeanFactory getACBF() {
        return this.appContext.getAutowireCapableBeanFactory();
    }

    public static <T> T getBean(Class<T> clazz) {
        return clazz.cast(SpringUtils.getInstance().getACBF().getBean(clazz));
    }

    public boolean hasBean(Class<?> clazz) {
        try {
            SpringUtils.getBean(clazz);
            return true;
        }
        catch (NoSuchBeanDefinitionException e) {
            return false;
        }
    }

    public boolean hasBeanNames(Class<?> clazz) {
        try {
            DefaultListableBeanFactory reg = (DefaultListableBeanFactory)this.appContext.getAutowireCapableBeanFactory();
            return reg.getBeanNamesForType(clazz).length > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ConfigurableBeanFactory getConfigurableBeanFactory() {
        return (ConfigurableBeanFactory)this.appContext.getAutowireCapableBeanFactory();
    }

    public void registerSingletonBean(String ifaceName, Object singleton) {
        ConfigurableBeanFactory reg = (ConfigurableBeanFactory)this.appContext.getAutowireCapableBeanFactory();
        reg.registerSingleton(ifaceName, singleton);
    }

    public void unregisterSingletonBean(String ifaceName) {
        DefaultListableBeanFactory reg = (DefaultListableBeanFactory)this.appContext.getAutowireCapableBeanFactory();
        reg.destroySingleton(ifaceName);
    }

    public void registerAndAutowire(Class<?> iface) {
        try {
            Object singleton = iface.newInstance();
            this.autowire(singleton);
            this.registerSingletonBean(iface.getCanonicalName(), singleton);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate", e);
        }
    }

    public void registerAndAutowire(Class<?> iface, Object singleton) {
        this.autowire(singleton);
        this.registerSingletonBean(iface.getCanonicalName(), singleton);
    }

    public void registerSingletonBean(Class<?> iface, Object singleton) {
        this.registerSingletonBean(iface.getCanonicalName(), singleton);
    }

    public synchronized void registerSingletonBeanIfNotPresent(Class<?> iface, Object singleton) {
        if (!this.hasBeanNames(iface)) {
            this.registerSingletonBean(iface.getCanonicalName(), singleton);
        }
    }

    public void unregisterSingletonBean(Class<?> iface) {
        this.unregisterSingletonBean(iface.getCanonicalName());
    }

    public static void onDSSStarted() {
        logger.info((Object)("Publishing event " + DSSStartedEvent.class.getSimpleName()));
        SpringUtils.instance.appContext.publishEvent((ApplicationEvent)new DSSStartedEvent(instance));
    }

    static {
        logger = DKULogger.getLogger((String)"dku.springutils");
    }
}

