import os, json
from dataiku.cluster import Cluster

class MyCluster(Cluster):
    def __init__(self, cluster_id, cluster_name, config, plugin_config):
        """
        :param cluster_id: the DSS identifier for this instance of cluster
        :param cluster_name: the name given by the user to this cluster
        :param config: the dict of the configuration of the object
        :param plugin_config: contains the plugin settings
        """
        self.config = config
        self.plugin_config = plugin_config
        
    def start(self):
        """
        Make the cluster operational in DSS, creating an actual cluster if necessary.
        
        :returns: a tuple of : 
                  * the settings needed to access hadoop/hive/impala/spark on the cluster. If not
                    specified, then the corresponding element (hadoop/hive/impala/spark) is not overriden
                  * an dict of data to pass to to other methods when handling the cluster created
        """
        return [{'hadoop':{}, 'hive':{}, 'impala':{}, 'spark':{}}, {'info':'some useful info', 'prop':'and some more'}]

    def stop(self, data):
        """
        Stop the cluster
        
        :param data: the dict of data that the start() method produced for the cluster
        """
        pass

