var type = require("./type"),
    topojson = require("../../");

module.exports = function(topology, options) {
  var verbose = false,
      retained = [],
      j = -1,
      n = topology.arcs.length;

  if (options)
    "verbose" in options && (verbose = !!options["verbose"]);

  var prune = type({
    LineString: function(lineString) {
      this.line(lineString.arcs);
    },
    MultiLineString: function(multiLineString) {
      var arcs = multiLineString.arcs, i = -1, n = arcs.length;
      while (++i < n) this.line(arcs[i]);
    },
    MultiPoint: noop,
    MultiPolygon: function(multiPolygon) {
      var arcs = multiPolygon.arcs, i = -1, n = arcs.length;
      while (++i < n) this.polygon(arcs[i]);
    },
    Point: noop,
    Polygon: function(polygon) {
      this.polygon(polygon.arcs);
    },
    line: function(arcs) {
      var i = -1, n = arcs.length, arc, reversed;
      while (++i < n) {
        arc = arcs[i];
        if (reversed = arc < 0) arc = ~arc;
        if (retained[arc] == null) retained[arc] = ++j, arc = j;
        else arc = retained[arc];
        arcs[i] = reversed ? ~arc : arc;
      }
    },
    polygon: function(arcs) {
      var i = -1, n = arcs.length;
      while (++i < n) this.line(arcs[i]);
    }
  });

  for (var key in topology.objects) {
    prune.object(topology.objects[key]);
  }

  if (verbose) console.warn("prune: retained " + (j + 1) + " / " + n + " arcs (" + Math.round((j + 1) / n * 100) + "%)");

  var arcs = [];
  retained.forEach(function(i, j) { arcs[i] = topology.arcs[j]; });
  topology.arcs = arcs;
};

function noop() {}
