/* jshint loopfunc: true*/
(function() {
    'use strict';

    const app = angular.module('dataiku.charts')

    // (!) This service previously was in static/dataiku/js/simple_report/webapps/webapp_chart.js
    app.factory('WebappChart', function(DataikuAPI, $stateParams, VirtualWebApp, SmartId) {
        return function($container, chartDef, data, $scope) {
            $scope.chartDef = chartDef;
            $scope.uiDisplayState = $scope.uiDisplayState || {};
            $scope.storedWebAppId = $scope.chartDef.$storedWebAppId;

            const datasetSmartName = SmartId.create(data.datasetName, data.projectKey);
            // set the dataset name into the config
            if ($scope.chartDef.$pluginChartDesc.datasetParamName) {
                $scope.chartDef.webAppConfig[$scope.chartDef.$pluginChartDesc.datasetParamName] = datasetSmartName;
            }
            const hooks = {
                webAppConfigPreparation: function(chartDef) {
                    const strippedChartDef = angular.copy(chartDef);
                    Object.keys($scope.chartDef).filter(function(k) {
                        return k.startsWith('$');
                    }).forEach(function(k) {
                        delete strippedChartDef[k];
                    });
                    return strippedChartDef;
                },
                stopFunction: function() {
                    return $scope.chartDef.type != 'webapp';
                },
                handleError: $scope.chartSetErrorInScope,
                webAppReady: function(webAppId) {
                    $scope.chartDef.$storedWebAppId = webAppId; // don't put in localstorage, just keep it in the chartDef (temporarily)
                }
            };

            $scope.uiDisplayState.skinWebApp = { noConfigWatch: true };
            VirtualWebApp.update($scope, $container, 'chartDef.webAppType', 'chartDef', DataikuAPI.explores.getOrCreatePluginChart.bind($scope, $stateParams.projectKey, datasetSmartName, chartDef), $scope.uiDisplayState.skinWebApp, hooks);
        }
    });
})();
