/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features multi_columns_lines', function () {

    const chartType = 'multi_columns_lines';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('has axis options', function () {
        ChartFeaturesTestUtils.setXYGenericFromNumericalColumns();
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);

        $('.measure-wrapper')[0].click(); // in Y
        expectIdToBeVisible('qa_charts_multi-y-axis-select');
        expectIdToBeVisible('qa_charts_multiplot-mode-select');
        expectIdToBeVisible('qa_charts_computation-type-select');

        $('.measure-wrapper')[1].click(); // in X
        expectIdToBeVisible('qa_charts_one-tick-per-bin-select');
        expectIdToBeVisible('qa_charts_handling-empty-bins-select');
    })

    it('doesn\'t have along dimension option', function () {
        ChartFeaturesTestUtils.computeAlongDimensionSelectTests(chartType, 'NORMAL', false);
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});
