from .code_studio_block import CodeStudioBlock
from .code_studio_template import CodeStudioTemplate

import os
import os.path as osp
import logging
import re

logging.basicConfig(level=logging.INFO, format='%(asctime)s %(levelname)s %(message)s')

# keep in sync with the method in build-images.py
def get_dataiku_user_uid():
    DIP_HOME = os.environ["DIP_HOME"]
    try:
        path = osp.join(DIP_HOME, "config/dip.properties")
        if not os.path.exists(path):
            return "500"
        with open(path, "r") as f:
            for line in f.readlines():
                match = re.match(r"^dku.container.dataiku.uid\s*=\s*(\w+)$", line)
                if match:
                    return match.group(1)
    except Exception as e:
        logging.error("Could not read dip properties json file", exc_info=e)
    return "500"
