import dataiku
import mlflow
from sklearn.linear_model import ElasticNet

client = dataiku.api_client()
project = client.get_project(dataiku.default_project_key())

# Setup mlflow integration, storing artefacts in managed folder. Managed folder must already exist.
mlflow_handle = project.setup_mlflow('A_MANAGED_FOLDER_ID')

# MLflow run and experiment will be sent to DSS backend.
mlflow.set_experiment("sample autolog")

# activate Mflow autologging
mlflow.sklearn.autolog()

# ... load train data, set parameters ...

with mlflow.start_run(run_name="my_run"):
    lr = ElasticNet(alpha=alpha, l1_ratio=l1_ratio, random_state=42)
    lr.fit(train_x, train_y)


mlflow_handle.clear()
