$DKU_R_ENV_PATH=$args[0]
$CONDA_MODE=$args[1]
$SPEC_FILE=$args[2]
$MAIN_REPOS=$args[3]

$TARGET_LIB="$DKU_R_ENV_PATH/R.lib"

if ($MAIN_REPOS) {
    $REPOS="`"$MAIN_REPOS`""
} else {
    $REPOS="NULL"
}

$SPEC_FILE=$SPEC_FILE.Replace("\", "/")
$TARGET_LIB=$TARGET_LIB.Replace("\", "/")
$REPOS=$REPOS.Replace("\", "/")

Write-Host "Installing from $REPOS"
Write-Host "Installing from $TARGET_LIB"

@"
print("known library paths:")
print(.libPaths())

dependencies <- read.table("$SPEC_FILE", col.names=c("pkg", "ver"), sep=",",stringsAsFactors=FALSE, fill=TRUE)

checkPackages <- function() {
    message("Checking installed packages ...")
    installedVersions <- installed.packages(noCache=TRUE)[,'Version']
    print("already has : ")
    print(installedVersions)
    l <- apply(dependencies, 1, function(x) {
        p <- x['pkg']
        v <- x['ver']
        if (is.na(installedVersions[p])) {
            message("Package not installed: ", p)
            p
        } else if (is.na(v) || v == "") {
            message("No version requested for ", p, " considering installed version OK:", installedVersions[p])
            NA
        } else if (package_version(installedVersions[p]) < package_version(v)) {
            message("Package too old: ", p, " installed=", installedVersions[p] , " required=", v)
            p
        } else {
            NA
        }
    })
    na.omit(l)
}

toInstall <- checkPackages()
if (length(toInstall) > 0) {
    message("Installing packages: ", paste(toInstall, collapse=" "))
    install.packages(toInstall, "$TARGET_LIB",
        Ncpus=8, repos=c($REPOS))
    if (length(checkPackages()) > 0) {
        stop("at least one package failed to install required version")
    }
}
"@ | & "$($args[0])/bin/R" "--slave" "--no-restore"
