/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.utils.TestFlag;
import com.dataiku.lambda.LambdaContext;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class StdLambdaContext
extends LambdaContext {
    MetricRegistry metrics = new MetricRegistry();
    HealthCheckRegistry healthCheckRegistry = new HealthCheckRegistry();
    @VisibleForTesting
    public static final TestFlag determineLambdaHomeFromApplicationConfigurator = new TestFlag();

    public MetricRegistry getRegistry() {
        return this.metrics;
    }

    public synchronized void setHealthChecksForService(String serviceId, Map<String, HealthCheck> healthChecks) {
        ArrayList<String> namesToRemove = new ArrayList<String>();
        for (String string : this.healthCheckRegistry.getNames()) {
            if (!string.startsWith("apinode.services.")) continue;
            namesToRemove.add(string);
        }
        for (String string : namesToRemove) {
            this.healthCheckRegistry.unregister(string);
        }
        for (Map.Entry entry : healthChecks.entrySet()) {
            this.healthCheckRegistry.register("apinode.services." + (String)entry.getKey(), (HealthCheck)entry.getValue());
        }
    }

    public HealthCheckRegistry getHealthChecks() {
        return this.healthCheckRegistry;
    }

    public File getRootDir() {
        if (determineLambdaHomeFromApplicationConfigurator.isActivated()) {
            return ApplicationConfigurator.getBaseFolderF();
        }
        return new File(System.getenv("DKU_LAMBDA_HOME"));
    }
}

