/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.admin;

import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.lambda.auth.ApiNodeAuthVerificationService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.AliveService;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class IsAliveController
extends LambdaAPIControllerBase {
    @Autowired
    private AliveService aliveService;
    @Autowired
    private ServicesService servicesService;
    @Autowired
    private ApiNodeAuthVerificationService authService;

    @RequestMapping(value={"/isAlive"})
    public void isAlive(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean checkAdmin) throws Exception {
        JsonObject ret = new JsonObject();
        if (checkAdmin) {
            try {
                this.authService.checkAdmin(req);
                ret.addProperty("adminChecked", Boolean.valueOf(true));
            }
            catch (NotAuthenticatedException | UnauthorizedException e) {
                ret.addProperty("adminChecked", Boolean.valueOf(false));
            }
        }
        if ((ret = this.aliveService.isAlive(ret)).get("alive").getAsBoolean()) {
            IsAliveController.writeJSON(resp, ret);
        } else {
            IsAliveController.setHeader(resp);
            resp.setStatus(503);
            DIPInternalControllerBase.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    private String getNotAliveReason(String serviceId) {
        ServiceManager manager = this.servicesService.getServiceManagerCheck(serviceId);
        return manager.getNotAliveSimpleReason();
    }

    @RequestMapping(value={"/monitoring/api/isFullyAlive"})
    public void isFullyAlive(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<ServicesService.ServiceSummaryState> summaries = this.servicesService.listServices();
        for (ServicesService.ServiceSummaryState serviceSummary : summaries) {
            String reason = this.getNotAliveReason(serviceSummary.serviceId);
            if (reason == null) continue;
            throw new IllegalArgumentException(String.format("The service with id %s is not alive. %s", serviceSummary.serviceId, reason));
        }
        this.writeSimpleOK(resp);
    }

    @RequestMapping(value={"/monitoring/api/{serviceId}/isAliveSimple"})
    public void isServiceAvailableSimple(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        String reason = this.getNotAliveReason(serviceId);
        if (reason != null) {
            throw new IllegalArgumentException(reason);
        }
        this.writeSimpleOK(resp);
    }
}

