/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.IEndpointFactory;
import com.dataiku.lambda.endpoints.LambdaEndpointHandler;
import com.dataiku.lambda.endpoints.custompredict.CustomPythonPredictionEndpointHandler;
import com.dataiku.lambda.endpoints.custompredict.CustomRPredictionEndpointHandler;
import com.dataiku.lambda.endpoints.datasetlookup.DatasetsLookupEndpointHandler;
import com.dataiku.lambda.endpoints.predict.PredictionEndpointHandler;
import com.dataiku.lambda.endpoints.pyfunction.PyFunctionEndpointHandler;
import com.dataiku.lambda.endpoints.rfunction.RFunctionEndpointHandler;
import com.dataiku.lambda.endpoints.sqlquery.SQLQueryEndpointHandler;
import com.dataiku.lambda.model.serverconfig.CustomPythonPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.CustomRPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.DatasetsLookupEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PyFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.RFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.SQLQueryEndpointConfig;
import java.io.IOException;
import java.sql.SQLException;

public class EndpointFactory
implements IEndpointFactory {
    @Override
    public LambdaEndpointHandler<?> build(LambdaEndpointConfig config, ServiceGenContext context) throws IOException, SQLException, DKUSecurityException {
        switch (config.type) {
            case STD_PREDICTION: 
            case STD_CAUSAL_PREDICTION: 
            case STD_FORECAST: 
            case STD_CLUSTERING: {
                return new PredictionEndpointHandler((PredictionEndpointConfig)config);
            }
            case CUSTOM_PREDICTION: {
                return new CustomPythonPredictionEndpointHandler((CustomPythonPredictionEndpointConfig)config);
            }
            case CUSTOM_R_PREDICTION: {
                return new CustomRPredictionEndpointHandler((CustomRPredictionEndpointConfig)config);
            }
            case R_FUNCTION: {
                return new RFunctionEndpointHandler((RFunctionEndpointConfig)config);
            }
            case PY_FUNCTION: {
                return new PyFunctionEndpointHandler((PyFunctionEndpointConfig)config);
            }
            case SQL_QUERY: {
                return new SQLQueryEndpointHandler((SQLQueryEndpointConfig)config);
            }
            case DATASETS_LOOKUP: {
                return new DatasetsLookupEndpointHandler((DatasetsLookupEndpointConfig)config);
            }
        }
        throw new Error("unimplemneted");
    }
}

