/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.predict;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.kernels.AbstractLambdaPythonKernel;
import com.dataiku.lambda.ServiceGenContext;
import com.dataiku.lambda.endpoints.predict.PredictionModelPredictionStep;
import com.dataiku.lambda.endpoints.predict.PythonPredictionKernel;
import com.dataiku.lambda.endpoints.predictcommon.AbstractPythonPredictionStep;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonPredictionStep
extends PredictionModelPredictionStep {
    private final Map<String, SchemaColumn> preparationOutputSchemaMap = new HashMap<String, SchemaColumn>();
    private final Schema preparationOutputSchema;
    @Autowired
    PasswordEncryptionService passwordEncryptionService;

    public PythonPredictionStep(PredictionEndpointConfig ep, ServiceGenContext ctx, File modelFolder) throws IOException {
        super(ep, ctx, modelFolder);
        SpringUtils.getInstance().autowire((Object)this);
        if (new File(modelFolder, "split/split.json").isFile()) {
            SplitDesc sd = (SplitDesc)JSON.parseFile((File)new File(modelFolder, "split/split.json"), SplitDesc.class);
            this.preparationOutputSchema = sd.schema;
            for (SchemaColumn col : sd.schema.getColumns()) {
                this.preparationOutputSchemaMap.put(col.getName(), col);
            }
        } else {
            this.preparationOutputSchema = null;
        }
    }

    @Override
    public String getKernelNamePrefix() {
        return "pred-";
    }

    @Override
    public AbstractLambdaPythonKernel initializeKernel() {
        return new PythonPredictionKernel(this.link, this.ctx, this.endpointConfig.id, (List<String>)this.codePaths, this.codeEnvFolder, this.pluginResourcesEnv, (File)this.kernelWorkDir, ApplicationConfigurator.isDevLambdaServer(), (GeneralSettingsDAO.CGrouppableProcessType)(ApplicationConfigurator.isDevLambdaServer() ? GeneralSettingsDAO.CGrouppableProcessType.LAMBDA_DEV_SERVER : null));
    }

    @Override
    public PredictionResponse process(PipelineMessage message) throws Exception {
        AbstractPythonPredictionStep.InternalPredictionResponse iret;
        AbstractPythonPredictionStep.PreparedRecords records = this.toRecords(message, this.preparationOutputSchemaMap, this.passwordEncryptionService);
        if (message.pyPredictionAdvancedOptions != null) {
            records.obj.add("pyPredictionAdvancedOptions", (JsonElement)JSON.toJsonObject((Object)message.pyPredictionAdvancedOptions));
        }
        if (this.preparationOutputSchema != null) {
            records.obj.add("schema", (JsonElement)JSON.toJsonObject((Object)this.preparationOutputSchema));
        }
        logger.debug((Object)"Sending query to prediction handler");
        if (records.serialized > 0) {
            try {
                iret = (AbstractPythonPredictionStep.InternalPredictionResponse)this.link.execute((Object)records.obj, AbstractPythonPredictionStep.InternalPredictionResponse.class, "Failed to get prediction");
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail((IDSSKernelBase)this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
        } else {
            for (int i = 0; i < message.prePredictIgnoreReasons.size(); ++i) {
                assert (message.prePredictIgnoreReasons.get(i) != null);
            }
            iret = new AbstractPythonPredictionStep.InternalPredictionResponse();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Got prediction result: " + JSON.json((Object)iret)));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Got prediction result");
        }
        PredictionResponse ret = this.toResponse(message, iret);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("RET:" + JSON.json((Object)ret)));
        }
        return ret;
    }
}

