/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.uniquedb;

import com.dataiku.geoip.uniquedb.InvalidDatabaseException;
import com.dataiku.geoip.uniquedb.Node;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.Adler32;

public final class UniqueDB {
    private final Node root;
    protected final String data;
    protected final int[] meta;
    private static final int VERSION_ID = 1;
    private static final int UDB_MARKER = 1433486402;

    public Node root() {
        return this.root;
    }

    public void writeToStream(DataOutputStream dos) throws IOException {
        Adler32 checksum = new Adler32();
        dos.writeInt(1433486402);
        dos.writeInt(1);
        byte[] dataBytes = this.data.getBytes("UTF-8");
        checksum.update(dataBytes);
        dos.writeInt(dataBytes.length);
        dos.write(dataBytes);
        dos.writeInt(this.meta.length);
        for (int i = 0; i < this.meta.length; ++i) {
            int v = this.meta[i];
            checksum.update(v);
            dos.writeInt(v);
        }
        dos.writeLong(checksum.getValue());
    }

    public static UniqueDB loadFromStream(DataInputStream dis) throws InvalidDatabaseException {
        try {
            Adler32 checksum = new Adler32();
            if (dis.readInt() != 1433486402) {
                throw new InvalidDatabaseException("Unknown file format");
            }
            if (dis.readInt() != 1) {
                throw new InvalidDatabaseException("Incompatible UniqueDB version");
            }
            int dataLength = dis.readInt();
            byte[] dataBytes = new byte[dataLength];
            dis.readFully(dataBytes);
            checksum.update(dataBytes);
            String data = new String(dataBytes, "UTF-8");
            dataBytes = null;
            int metaLength = dis.readInt();
            int[] meta = new int[metaLength];
            for (int i = 0; i < meta.length; ++i) {
                int v;
                meta[i] = v = dis.readInt();
                checksum.update(v);
            }
            if (checksum.getValue() != dis.readLong()) {
                throw new InvalidDatabaseException("Cannot load UniqueDB (invalid checksum)");
            }
            return new UniqueDB(data, meta);
        }
        catch (IOException e) {
            throw new InvalidDatabaseException("Cannot load UniqueDB (I/O error)", e);
        }
    }

    public UniqueDB(String data, int[] meta) {
        this.root = new Node(this, meta[0]);
        this.data = data;
        this.meta = meta;
    }
}

