/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.sandbox.hive.common;

import com.dataiku.hproxy.sandbox.hive.common.HiveSession;
import com.dataiku.hproxy.utils.Reflector;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.log4j.Logger;

public class ReflectedHiveCallCache {
    private final Reflector reflect;
    private QueryPlanCreate queryPlanCreator = null;
    private DriverContextCreate driverContextCreator = null;
    private VariableSubstitutionCreate variableSubstitutionCreator = null;
    private Map<String, Integer> hiveTokens = Maps.newHashMap();
    private SemanticAnalyzerCreate semanticAnalyzerCreator = null;
    private HiveTaskExecutor hiveTaskExecutor = null;
    private ParseDriverParse parseDriverParse = null;
    private CommandProcessorRun commandProcessorRun = null;
    private static Logger logger = Logger.getLogger(ReflectedHiveCallCache.class);

    public ReflectedHiveCallCache(ClassLoader cl) {
        this.reflect = new Reflector(cl);
    }

    public ASTNode reflectedParseUtilsFindRootNonNullToken(ASTNode tree) {
        try {
            return (ASTNode)this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.ParseUtils", "findRootNonNullToken", new Object[]{tree});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn((Object)"Failed to call findRootNonNullToken by reflection", (Throwable)e);
            return ParseUtils.findRootNonNullToken((ASTNode)tree);
        }
    }

    public void reflectedParseUtilsHandleSetColRefs(ASTNode tree, Context ctx) {
        try {
            this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.ParseUtils", "handleSetColRefs", new Object[]{tree, ctx});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn((Object)"Failed to call handleSetColRefs with context param by reflection", (Throwable)e);
            try {
                this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.ParseUtils", "handleSetColRefs", new Object[]{tree});
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e2) {
                logger.warn((Object)"Failed to call handleSetColRefs by reflection", (Throwable)e2);
            }
        }
    }

    public QueryPlan createQueryPlan(String str, BaseSemanticAnalyzer sem, HiveSession session) {
        if (this.queryPlanCreator != null) {
            try {
                return this.queryPlanCreator.create(str, sem, session);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate an instance of a QueryPlan", e);
            }
        }
        Throwable ex = null;
        for (QueryPlanCreate creator : this.getQueryPlanCreators()) {
            try {
                QueryPlan queryPlan = creator.create(str, sem, session);
                this.queryPlanCreator = creator;
                return queryPlan;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a QueryPlan (" + creator.getHiveVersion() + ")"), e);
                ex = e;
            }
        }
        throw new RuntimeException("Unable to instantiate QueryPlans", ex);
    }

    private QueryPlanCreate[] getQueryPlanCreators() {
        return new QueryPlanCreate[]{new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis()});
            }

            @Override
            public String getHiveVersion() {
                return "Hive up to 1.0";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), ""});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 0.14 and 1.0, CDH Hive 0.12-CDH5.1";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), "", "dku-validate"});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 1.1";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), "", "dku-validate", new Schema()});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 1.1, CDH Hive 1.1.0-CDH5.5";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                Object operation = ReflectedHiveCallCache.this.reflect.call((Object)session.getSessionState(), "getHiveOperation", new Object[0]);
                logger.info((Object)("Found hive operation: " + (operation != null ? operation.toString() : "**none**")));
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), "", operation, new Schema()});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 1.2.1";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                Object operationName = ReflectedHiveCallCache.this.reflect.call((Object)session.getSessionState(), "getCommandType", new Object[0]);
                operationName = operationName != null ? operationName.toString() : "";
                logger.info((Object)("Found hive operation: " + String.valueOf(operationName)));
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), "", operationName, session.getSessionState().getSessionId(), Thread.currentThread().getName(), ""});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 1.2.1, HDP 2.3.4";
            }
        }, new QueryPlanCreate(){

            @Override
            public QueryPlan create(String str, BaseSemanticAnalyzer sem, HiveSession session) throws Exception {
                Object queryState = ReflectedHiveCallCache.this.reflect.call((Object)sem, "getQueryState", new Object[0]);
                Object operation = ReflectedHiveCallCache.this.reflect.call(queryState, "getHiveOperation", new Object[0]);
                logger.info((Object)("Found hive operation: " + (operation != null ? operation.toString() : "**none**")));
                return (QueryPlan)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryPlan", new Object[]{str, sem, System.currentTimeMillis(), "", operation, new Schema()});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 2.1";
            }
        }};
    }

    public DriverContext createDriverContext(Queue<Task<? extends Serializable>> runnable, Context ctx, BaseSemanticAnalyzer sem) {
        if (this.driverContextCreator != null) {
            try {
                return this.driverContextCreator.create(runnable, ctx, sem);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate an instance of a DriverContext", e);
            }
        }
        for (DriverContextCreate creator : this.getDriverContextCreators()) {
            try {
                DriverContext driverContext = creator.create(runnable, ctx, sem);
                this.driverContextCreator = creator;
                return driverContext;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a DriverContext (" + creator.getHiveVersion() + ")"), e);
            }
        }
        logger.error((Object)"Unable to instanciate DriverContext");
        return null;
    }

    private DriverContextCreate[] getDriverContextCreators() {
        return new DriverContextCreate[]{new DriverContextCreate(){

            @Override
            public DriverContext create(Queue<Task<? extends Serializable>> runnable, Context ctx, BaseSemanticAnalyzer sem) throws Exception {
                return (DriverContext)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.DriverContext", new Object[]{runnable, ctx});
            }

            @Override
            public String getHiveVersion() {
                return "Hive <=0.12";
            }
        }, new DriverContextCreate(){

            @Override
            public DriverContext create(Queue<Task<? extends Serializable>> runnable, Context ctx, BaseSemanticAnalyzer sem) throws Exception {
                return (DriverContext)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.DriverContext", new Object[]{ctx});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 0.13";
            }
        }, new DriverContextCreate(){

            @Override
            public DriverContext create(Queue<Task<? extends Serializable>> runnable, Context ctx, BaseSemanticAnalyzer sem) throws Exception {
                Object queryState = ReflectedHiveCallCache.this.reflect.call((Object)sem, "getQueryState", new Object[0]);
                return (DriverContext)ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.DriverContext", new Object[]{queryState, null, null, null, null});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 3.1";
            }
        }};
    }

    public int executeTask(BaseSemanticAnalyzer semanticAnalyzer, HiveSession session, Task<? extends Serializable> task, HiveConf conf, Context context, DriverContext driverContext, QueryPlan queryPlan) {
        if (this.hiveTaskExecutor != null) {
            try {
                return this.hiveTaskExecutor.execute(semanticAnalyzer, session, task, conf, context, driverContext, queryPlan);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate an instance of a DriverContext", e);
            }
        }
        Throwable ex = null;
        for (HiveTaskExecutor executor : this.getHiveTaskExecutors()) {
            try {
                int code = executor.execute(semanticAnalyzer, session, task, conf, context, driverContext, queryPlan);
                this.hiveTaskExecutor = executor;
                return code;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a HiveTaskExecutor (" + executor.getHiveVersion() + ")"), e);
                ex = e;
            }
        }
        throw new RuntimeException("Unable to instanciate HiveTaskExecutor", ex);
    }

    private HiveTaskExecutor[] getHiveTaskExecutors() {
        return new HiveTaskExecutor[]{new HiveTaskExecutor(){

            @Override
            public int execute(BaseSemanticAnalyzer semanticAnalyzer, HiveSession session, Task<? extends Serializable> task, HiveConf conf, Context context, DriverContext driverContext, QueryPlan queryPlan) {
                task.initialize(conf, queryPlan, driverContext);
                return task.executeTask();
            }

            @Override
            public String getHiveVersion() {
                return "Hive <= 2.1";
            }
        }, new HiveTaskExecutor(){

            @Override
            public int execute(BaseSemanticAnalyzer semanticAnalyzer, HiveSession session, Task<? extends Serializable> task, HiveConf conf, Context context, DriverContext driverContext, QueryPlan queryPlan) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Object queryState = ReflectedHiveCallCache.this.reflect.call((Object)semanticAnalyzer, "getQueryState", new Object[0]);
                Object compilationOpContext = ReflectedHiveCallCache.this.reflect.call((Object)context, "getOpContext", new Object[0]);
                ReflectedHiveCallCache.this.reflect.call(task, "initialize", new Object[]{queryState, queryPlan, driverContext, compilationOpContext});
                return task.executeTask();
            }

            @Override
            public String getHiveVersion() {
                return "Hive 2.1";
            }
        }, new HiveTaskExecutor(){

            @Override
            public int execute(BaseSemanticAnalyzer semanticAnalyzer, HiveSession session, Task<? extends Serializable> task, HiveConf conf, Context context, DriverContext driverContext, QueryPlan queryPlan) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Object queryState = ReflectedHiveCallCache.this.reflect.call((Object)semanticAnalyzer, "getQueryState", new Object[0]);
                Object compilationOpContext = ReflectedHiveCallCache.this.reflect.call((Object)context, "getOpContext", new Object[0]);
                ReflectedHiveCallCache.this.reflect.call(task, "initialize", new Object[]{queryState, queryPlan, driverContext, compilationOpContext});
                return (Integer)ReflectedHiveCallCache.this.reflect.call(task, "executeTask", new Object[]{null});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 3";
            }
        }, new HiveTaskExecutor(){

            @Override
            public int execute(BaseSemanticAnalyzer semanticAnalyzer, HiveSession session, Task<? extends Serializable> task, HiveConf conf, Context context, DriverContext driverContext, QueryPlan queryPlan) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Object queryState = ReflectedHiveCallCache.this.reflect.call((Object)driverContext, "getQueryState", new Object[0]);
                Object taskQueue = ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.TaskQueue", new Object[]{context});
                ReflectedHiveCallCache.this.reflect.call(taskQueue, "addToRunnable", new Object[]{task});
                ReflectedHiveCallCache.this.reflect.call(task, "initialize", new Object[]{queryState, queryPlan, taskQueue, context});
                return (Integer)ReflectedHiveCallCache.this.reflect.call(task, "executeTask", new Object[]{null});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 3.1";
            }
        }};
    }

    public int hiveToken(String tok) {
        if (this.hiveTokens.containsKey(tok)) {
            if (this.hiveTokens.get(tok) == null) {
                throw new RuntimeException("Unable to find token \"" + tok + "\"");
            }
            return this.hiveTokens.get(tok);
        }
        try {
            int value = (Integer)this.reflect.getStaticAttribute("org.apache.hadoop.hive.ql.parse.HiveParser", tok);
            this.hiveTokens.put(tok, value);
            return value;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to find token \"" + tok + "\"", e);
        }
    }

    public VariableSubstitutionWrapper createVariableSubstitution() {
        if (this.variableSubstitutionCreator != null) {
            try {
                return this.variableSubstitutionCreator.create();
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate an instance of a VariableSubstitution", e);
            }
        }
        Throwable ex = null;
        for (VariableSubstitutionCreate creator : this.getVariableSubstitutionCreators()) {
            try {
                VariableSubstitutionWrapper variableSubstitutionWrapper = creator.create();
                this.variableSubstitutionCreator = creator;
                return variableSubstitutionWrapper;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a VariableSubstitution (" + creator.getHiveVersion() + ")"), e);
                ex = e;
            }
        }
        throw new RuntimeException("Unable to instantiate VariableSubstitutions", ex);
    }

    private VariableSubstitutionCreate[] getVariableSubstitutionCreators() {
        return new VariableSubstitutionCreate[]{new VariableSubstitutionCreate(){

            @Override
            public VariableSubstitutionWrapper create() throws Exception {
                final Object substitutor = ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.parse.VariableSubstitution", new Object[0]);
                return new VariableSubstitutionWrapper(){

                    @Override
                    public String substitute(HiveConf conf, String expr) {
                        try {
                            return (String)ReflectedHiveCallCache.this.reflect.call(substitutor, "substitute", new Object[]{conf, expr});
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                            logger.warn((Object)("Failed to substitute variables in " + expr), (Throwable)e);
                            return null;
                        }
                    }
                };
            }

            @Override
            public String getHiveVersion() {
                return "Hive up to 2.0";
            }
        }, new VariableSubstitutionCreate(){

            @Override
            public VariableSubstitutionWrapper create() throws Exception {
                Object hiveVariableSource = ReflectedHiveCallCache.this.reflect.getImplementationOf("org.apache.hadoop.hive.conf.HiveVariableSource", new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().startsWith("getHiveVariable")) {
                            return SessionState.get().getHiveVariables();
                        }
                        return null;
                    }
                });
                final Object substitutor = ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.conf.VariableSubstitution", new Object[]{hiveVariableSource});
                return new VariableSubstitutionWrapper(){

                    @Override
                    public String substitute(HiveConf conf, String expr) {
                        try {
                            return (String)ReflectedHiveCallCache.this.reflect.call(substitutor, "substitute", new Object[]{conf, expr});
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                            logger.warn((Object)("Failed to substitute variables in " + expr), (Throwable)e);
                            return null;
                        }
                    }
                };
            }

            @Override
            public String getHiveVersion() {
                return "Hive 2.0, in CDH 5.7";
            }
        }};
    }

    public BaseSemanticAnalyzer createSemanticAnalyzer(HiveConf conf, ASTNode node) {
        if (this.semanticAnalyzerCreator != null) {
            try {
                return this.semanticAnalyzerCreator.create(conf, node);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to instantiate an instance of a SemanticAnalyzer", e);
            }
        }
        for (SemanticAnalyzerCreate creator : this.getSemanticAnalyzerCreators()) {
            try {
                BaseSemanticAnalyzer semanticAnalyzer = creator.create(conf, node);
                this.semanticAnalyzerCreator = creator;
                return semanticAnalyzer;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a SemanticAnalyzer (" + creator.getHiveVersion() + ")"), e);
            }
        }
        logger.error((Object)"Unable to instanciate SemanticAnalyzer");
        return null;
    }

    private SemanticAnalyzerCreate[] getSemanticAnalyzerCreators() {
        return new SemanticAnalyzerCreate[]{new SemanticAnalyzerCreate(){

            @Override
            public BaseSemanticAnalyzer create(HiveConf conf, ASTNode node) throws Exception {
                return (BaseSemanticAnalyzer)ReflectedHiveCallCache.this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory", "get", new Object[]{conf, node});
            }

            @Override
            public String getHiveVersion() {
                return "Hive <= 2.1";
            }
        }, new SemanticAnalyzerCreate(){

            @Override
            public BaseSemanticAnalyzer create(HiveConf conf, ASTNode node) throws Exception {
                Object queryState = ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryState", new Object[]{conf});
                return (BaseSemanticAnalyzer)ReflectedHiveCallCache.this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory", "get", new Object[]{queryState, node});
            }

            @Override
            public String getHiveVersion() {
                return "Hive 2.1";
            }
        }, new SemanticAnalyzerCreate(){

            @Override
            public BaseSemanticAnalyzer create(HiveConf conf, ASTNode node) throws Exception {
                Object queryStateBuilder = ReflectedHiveCallCache.this.reflect.newInstance("org.apache.hadoop.hive.ql.QueryState$Builder", new Object[0]);
                ReflectedHiveCallCache.this.reflect.call(queryStateBuilder, "withHiveConf", new Object[]{conf});
                ReflectedHiveCallCache.this.reflect.call(queryStateBuilder, "withGenerateNewQueryId", new Object[]{true});
                Object queryState = ReflectedHiveCallCache.this.reflect.call(queryStateBuilder, "build", new Object[0]);
                SessionState state = SessionState.get();
                if (state != null) {
                    Object queryStateId = ReflectedHiveCallCache.this.reflect.call(queryState, "getQueryId", new Object[0]);
                    try {
                        ReflectedHiveCallCache.this.reflect.call((Object)state, "addQueryState", new Object[]{queryStateId, queryState});
                    }
                    catch (Exception exc) {
                        logger.warn((Object)"Unable to add query state, Hive version may not support it.", (Throwable)exc);
                    }
                }
                return (BaseSemanticAnalyzer)ReflectedHiveCallCache.this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory", "get", new Object[]{queryState, node});
            }

            @Override
            public String getHiveVersion() {
                return "Hive >= CDP 7.2.11";
            }
        }};
    }

    public ASTNode parseDriverParse(ParseDriver parseDriver, String command, Context context) {
        if (this.parseDriverParse != null) {
            try {
                return this.parseDriverParse.parse(parseDriver, command, context);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to parse a command", e);
            }
        }
        Throwable ex = null;
        for (ParseDriverParse parse : this.getParseDriverParses()) {
            try {
                ASTNode ast = parse.parse(parseDriver, command, context);
                this.parseDriverParse = parse;
                return ast;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a ParseDriverParse (" + parse.getHiveVersion() + ")"), e);
                ex = e;
            }
        }
        throw new RuntimeException("Unable to instantiate parse driver parses", ex);
    }

    private ParseDriverParse[] getParseDriverParses() {
        return new ParseDriverParse[]{new ParseDriverParse(){

            @Override
            public ASTNode parse(ParseDriver parseDriver, String command, Context context) throws Exception {
                return parseDriver.parse(command, context);
            }

            @Override
            public String getHiveVersion() {
                return "Hive < CDP 7.2.11";
            }
        }, new ParseDriverParse(){

            @Override
            public ASTNode parse(ParseDriver parseDriver, String command, Context context) throws Exception {
                return (ASTNode)ReflectedHiveCallCache.this.reflect.callStatic("org.apache.hadoop.hive.ql.parse.ParseUtils", "parse", new Object[]{command, context});
            }

            @Override
            public String getHiveVersion() {
                return "Hive >= CDP 7.2.11";
            }
        }};
    }

    public CommandProcessorResponseOrError commandProcessorRun(CommandProcessor p, String cmd) {
        if (this.commandProcessorRun != null) {
            try {
                return this.commandProcessorRun.run(p, cmd);
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to run a command processor", e);
            }
        }
        Throwable ex = null;
        for (CommandProcessorRun parse : this.getCommandProcessorRuns()) {
            try {
                CommandProcessorResponseOrError cpor = parse.run(p, cmd);
                this.commandProcessorRun = parse;
                return cpor;
            }
            catch (Throwable e) {
                logger.error((Object)("Failed tentative to create a CommandProcessorRun (" + parse.getHiveVersion() + ")"), e);
                ex = e;
            }
        }
        throw new RuntimeException("Unable to instantiate command processor runs", ex);
    }

    private CommandProcessorRun[] getCommandProcessorRuns() {
        return new CommandProcessorRun[]{new CommandProcessorRun(){

            @Override
            public CommandProcessorResponseOrError run(CommandProcessor p, String cmd) throws Exception {
                CommandProcessorResponseOrError ret = new CommandProcessorResponseOrError();
                ret.resp = p.run(cmd);
                if (ret.resp.getResponseCode() != 0) {
                    ret.error = new Exception(ret.resp.getErrorMessage());
                }
                return ret;
            }

            @Override
            public String getHiveVersion() {
                return "Hive < CDH 7.1.7 or 4.0.0";
            }
        }, new CommandProcessorRun(){

            @Override
            public CommandProcessorResponseOrError run(CommandProcessor p, String cmd) throws Exception {
                CommandProcessorResponseOrError ret = new CommandProcessorResponseOrError();
                try {
                    ret.resp = p.run(cmd);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to run command", (Throwable)e);
                    if ("CommandProcessorException".equals(e.getClass().getSimpleName())) {
                        ret.error = new Exception(e.toString());
                    }
                    throw e;
                }
                return ret;
            }

            @Override
            public String getHiveVersion() {
                return "Hive >= CDP 7.1.7 or 4.0.0";
            }
        }};
    }

    private static interface QueryPlanCreate {
        public QueryPlan create(String var1, BaseSemanticAnalyzer var2, HiveSession var3) throws Exception;

        public String getHiveVersion();
    }

    private static interface DriverContextCreate {
        public DriverContext create(Queue<Task<? extends Serializable>> var1, Context var2, BaseSemanticAnalyzer var3) throws Exception;

        public String getHiveVersion();
    }

    private static interface VariableSubstitutionCreate {
        public VariableSubstitutionWrapper create() throws Exception;

        public String getHiveVersion();
    }

    private static interface SemanticAnalyzerCreate {
        public BaseSemanticAnalyzer create(HiveConf var1, ASTNode var2) throws Exception;

        public String getHiveVersion();
    }

    public static interface HiveTaskExecutor {
        public int execute(BaseSemanticAnalyzer var1, HiveSession var2, Task<? extends Serializable> var3, HiveConf var4, Context var5, DriverContext var6, QueryPlan var7) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public String getHiveVersion();
    }

    private static interface ParseDriverParse {
        public ASTNode parse(ParseDriver var1, String var2, Context var3) throws Exception;

        public String getHiveVersion();
    }

    private static interface CommandProcessorRun {
        public CommandProcessorResponseOrError run(CommandProcessor var1, String var2) throws Exception;

        public String getHiveVersion();
    }

    public static interface VariableSubstitutionWrapper {
        public String substitute(HiveConf var1, String var2);
    }

    public static class CommandProcessorResponseOrError {
        public CommandProcessorResponse resp;
        public Exception error;
    }
}

