/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.docextraction.DocExtractionService;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.TextExtractionResponseOrError;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class PublicAPIDocExtractorController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DocExtractionService docExtractionService;

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/vlm"}, method={RequestMethod.POST})
    public TextExtractionResponseOrError runVLMExtractor(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        VLMExtractor.VLMExtractorRequest request = (VLMExtractor.VLMExtractorRequest)this.getRequestBodyAs(req, VLMExtractor.VLMExtractorRequest.class);
        if (request.settings.llmPrompt == null) {
            request.settings.llmPrompt = VLMExtractor.getVlmDefaultExtractionPrompt(null);
        }
        this.require(request.settings.llmId != null, "LLM ID is required to run VLM extraction");
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            List textChunks = this.docExtractionService.runVLMextractor(authCtx, projectKey, request);
            this.auditTrailService.generic("docextract-extract-vlm").with("llmId", request.settings.llmId).with("windowSize", (Number)request.settings.windowSize).with("windowOverlap", (Number)request.settings.windowOverlap).emit();
            return TextExtractionResponseOrError.fromSuccess((List)textChunks);
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-extract-vlm", (Throwable)e).with("projectKey", projectKey).with("llmId", request.settings.llmId).with("windowSize", (Number)request.settings.windowSize).with("windowOverlap", (Number)request.settings.windowOverlap).emit();
            return TextExtractionResponseOrError.fromError((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/structured"}, method={RequestMethod.POST})
    public StructuredExtractor.StructuredExtractionResponseOrError runStructuredExtractor(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart, @RequestParam(value="json") String structuredExtractorRequestStr) throws Exception {
        StructuredExtractor.StructuredExtractorRequest structuredExtractorRequest = (StructuredExtractor.StructuredExtractorRequest)JSON.parse((String)structuredExtractorRequestStr, StructuredExtractor.StructuredExtractorRequest.class);
        try {
            StructuredExtractor.StructuredExtractionResponseOrError res;
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, false);
            this.require(structuredExtractorRequest.inputs.document != null, "Input document should not be null");
            if (filePart != null) {
                if (!(structuredExtractorRequest.inputs.document instanceof InputRefs.LocalFileDocumentRef)) throw new IllegalArgumentException("If the request contains a multipart file, the input document ref should be LocalFileDocumentRef and not: " + structuredExtractorRequest.inputs.document.getClass().getName());
                res = this.docExtractionService.runStructuredExtractorFromInputStream(authCtx, projectKey, filePart.getInputStream(), filePart.getOriginalFilename(), structuredExtractorRequest.settings);
            } else {
                InputRefs.DocumentRef documentRef = structuredExtractorRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.ManagedFolderDocumentRef)) throw new IllegalArgumentException("Document ref: " + structuredExtractorRequest.inputs.document.getClass().getName() + " is not supported");
                InputRefs.ManagedFolderDocumentRef documentRef2 = (InputRefs.ManagedFolderDocumentRef)documentRef;
                res = this.docExtractionService.runStructuredExtractorFromManagedFolderDocumentRef(authCtx, projectKey, documentRef2, structuredExtractorRequest.settings);
            }
            this.auditTrailService.generic("docextract-extract-structured").with("projectKey", projectKey).with("maxSectionDepth", (Number)structuredExtractorRequest.settings.maxSectionDepth).emit();
            return res;
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-extract-structured", (Throwable)e).with("projectKey", projectKey).with("maxSectionDepth", (Number)structuredExtractorRequest.settings.maxSectionDepth).emit();
            return StructuredExtractor.StructuredExtractionResponseOrError.fromError((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/document-extractors/screenshotter"}, method={RequestMethod.POST})
    public Screenshotter.ScreenshotterResponseOrError runScreenshotter(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file", required=false) MultipartFile filePart, @RequestParam(value="json") String screenshotterRequestStr) throws Exception {
        Screenshotter.ScreenshotterRequest screenshotterRequest = (Screenshotter.ScreenshotterRequest)JSON.parse((String)screenshotterRequestStr, Screenshotter.ScreenshotterRequest.class);
        try {
            Screenshotter.ScreenshotterResponseOrError res;
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, screenshotterRequest.settings.outputManagedFolderId != null);
            if (filePart != null) {
                InputRefs.DocumentRef documentRef = screenshotterRequest.inputs.document;
                if (!(documentRef instanceof InputRefs.LocalFileDocumentRef)) throw new IllegalArgumentException("If the request contains a multipart file, the input document Ref should be LocalFileDocumentRef");
                InputRefs.LocalFileDocumentRef localFileDocumentRef = (InputRefs.LocalFileDocumentRef)documentRef;
                localFileDocumentRef.multipartFile = filePart;
                res = this.docExtractionService.extractScreenshotsFromLocalFileDocumentRef(authCtx, projectKey, localFileDocumentRef, screenshotterRequest.settings);
            } else {
                InputRefs.DocumentRef documentRef = screenshotterRequest.inputs.document;
                if (documentRef instanceof InputRefs.ManagedFolderDocumentRef) {
                    InputRefs.ManagedFolderDocumentRef managedFolderDocumentRef = (InputRefs.ManagedFolderDocumentRef)documentRef;
                    res = this.docExtractionService.extractScreenshotsFromManagedFolderDocumentRef(authCtx, projectKey, managedFolderDocumentRef, screenshotterRequest.settings);
                } else {
                    documentRef = screenshotterRequest.inputs.document;
                    if (!(documentRef instanceof InputRefs.TmpDocumentRef)) throw new IllegalArgumentException("Document ref is not supported");
                    InputRefs.TmpDocumentRef tmpDocumentRef = (InputRefs.TmpDocumentRef)documentRef;
                    res = this.docExtractionService.extractScreenshotsFromTmpDocumentRef(authCtx, projectKey, tmpDocumentRef, screenshotterRequest.settings);
                }
            }
            if (res.ok) {
                this.auditTrailService.generic("docextract-screenshot").with("lastResultIndex", (Number)res.lastResultIndex).with("hasMoreResults", res.hasMoreResults).with("totalResults", (Number)res.totalResults).emit();
                return res;
            } else {
                this.auditTrailService.failure("docextract-screenshot", res.throwable).with("projectKey", projectKey).emit();
            }
            return res;
        }
        catch (Exception e) {
            this.auditTrailService.failure("docextract-screenshot", (Throwable)e).with("projectKey", projectKey).emit();
            return Screenshotter.ScreenshotterResponseOrError.fromError((Throwable)e);
        }
    }

    private AuthCtx authAndCheckAccessAndSetCRUContext(HttpServletRequest req, String projectKey, boolean areWritePermissionsNeeded) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            if (areWritePermissionsNeeded) {
                this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsage((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }
}

