/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dashboards.export.DashboardExportFormatBuilder;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.export.model.DashboardExportRequest;
import com.dataiku.dip.dataflow.export.FlowExportFormatBuilder;
import com.dataiku.dip.dataflow.export.FlowExportService;
import com.dataiku.dip.dataflow.export.model.FlowExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.dataflow.export.model.FlowExportRequest;
import com.dataiku.dip.graphicsexport.BaseExportService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.graphicsexport.model.EnrichedExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportRequest;
import com.dataiku.dip.graphicsexport.wikis.WikiExportFormatBuilder;
import com.dataiku.dip.graphicsexport.wikis.WikiExportService;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExport;
import com.dataiku.dip.graphicsexport.wikis.model.WikiExportRequest;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}"})
public class PublicAPIGraphicExportController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    private FlowExportService flowExportService;
    @Autowired
    private WikiExportService wikiExportService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;

    @AuditedCall(value={"msgType", "create-single-dashboard-export", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/dashboards/{dashboardId}/actions/export"}, method={RequestMethod.POST})
    public void createDashboardExport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String dashboardId) throws Exception {
        DashboardExportRequest exportRequest = this.getExportRequest(req, DashboardExportRequest.class);
        List filtersBySlide = Optional.ofNullable(exportRequest.filtersBySlide).orElseGet(Collections::emptyList);
        this.genericExport(req, resp, (BaseExport)new DashboardExport(projectKey, new DashboardExportFormatBuilder((ExportRequest)exportRequest).build(), new DashboardExport.Target(dashboardId, filtersBySlide, exportRequest.slideIndex)), (BaseExportService)this.dashboardsExportService);
    }

    @AuditedCall(value={"msgType", "create-flow-export", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/flow/actions/export"}, method={RequestMethod.POST})
    public void createFlowExport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        this.genericExport(req, resp, (BaseExport)new FlowExport(projectKey, (FlowExportFormat)new FlowExportFormatBuilder(this.getExportRequest(req, FlowExportRequest.class)).build()), (BaseExportService)this.flowExportService);
    }

    @AuditedCall(value={"msgType", "create-wiki-article-export", "projectKey", "${projectKey}", "articleId", "${articleId}"})
    @RequestMapping(value={"/wiki/{articleId}/actions/export"}, method={RequestMethod.POST})
    public void createWikiArticleExport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String articleId) throws Exception {
        WikiExportRequest exportRequest = this.getExportRequest(req, WikiExportRequest.class);
        this.genericExport(req, resp, (BaseExport)new WikiExport(projectKey, new WikiExportFormatBuilder((ExportRequest)exportRequest).build(), articleId, exportRequest.exportChildren, exportRequest.exportAttachments), (BaseExportService)this.wikiExportService);
    }

    @AuditedCall(value={"msgType", "create-wiki-export", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/wiki/actions/export"}, method={RequestMethod.POST})
    public void createWikiExport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        WikiExportRequest exportRequest = this.getExportRequest(req, WikiExportRequest.class);
        this.genericExport(req, resp, (BaseExport)new WikiExport(projectKey, new WikiExportFormatBuilder((ExportRequest)exportRequest).build(), exportRequest.exportAttachments), (BaseExportService)this.wikiExportService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends BaseExport> void genericExport(HttpServletRequest req, HttpServletResponse resp, T export, BaseExportService<T, ? extends ExportFormat, ? extends EnrichedExport> exportService) throws Exception {
        AuthCtx authCtx;
        GeneralSettingsDAO.GeneralSettings settings;
        try (Transaction ignored = this.transactionService.beginRead();){
            settings = this.generalSettingsDAO.read();
            authCtx = this.authService.getTicketOrKey(req);
        }
        if (settings.graphicsExportsEnabled) {
            try {
                File file = exportService.exportAndWait((AuthCtx)authCtx, export).exportFile;
                resp.setStatus(201);
                String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
                this.writeFileForDownload(resp, file, mimeType, file.getName());
            }
            finally {
                exportService.clean(export.projectKey, export.exportId);
            }
        } else {
            PublicAPIGraphicExportController.writeJSON((HttpServletResponse)resp, (Object)"The graphics export feature is not installed on the instance.");
        }
    }

    private <T extends ExportRequest> T getExportRequest(HttpServletRequest req, Class<T> clazz) {
        ExportRequest exportRequest;
        try {
            exportRequest = (ExportRequest)this.getRequestBodyAs(req, clazz);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid request body: " + e.getMessage(), e);
        }
        return (T)exportRequest;
    }
}

