/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.llm.audit.ImageAuditManagedFolderService;
import com.dataiku.dip.llm.governance.GuardrailsBypassTokensService;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientFactory;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.llm.online.LLMMeshStreamClient;
import com.dataiku.dip.llm.utils.StreamingChunkEmitter;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.openai.OpenAIAPIConverter;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionRequest;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionResponse;
import com.dataiku.dip.server.api.openai.OpenAIModels;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPILLMController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GuardrailsBypassTokensService bypassTokensService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;
    @Autowired
    private ImageAuditManagedFolderService imageAuditService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    private static final String LLM_COMPLETION_AUDIT_CATEGORY = "llm-completion-query";

    private void checkAccessSavedModel(AuthCtx authCtx, String projectKey, String savedModelSmartId) throws IOException, DKUSecurityException {
        AnyLoc smartId = AnyLoc.resolveSmart((String)projectKey, (String)savedModelSmartId);
        String sourceProjectKey = smartId.getProjectKey();
        if (!Objects.equals(sourceProjectKey, projectKey)) {
            try {
                this.permissionsService.checkAnyProjectAccess(authCtx, sourceProjectKey);
            }
            catch (DKUSecurityException e) {
                this.projectsService.failIfNoSavedModelReadUseAccess(authCtx, smartId, projectKey);
            }
        }
    }

    private AuthCtx authAndSetCRUContext(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
        AuthCtx authCtx = authCtxUsage.getAuthCtx();
        this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
        ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsageWithFallback((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage, authx -> ComputeResourceUsageContext.forLLMAPI((AuthCtx)authCtx, (String)projectKey));
        return authCtx;
    }

    private AuthCtx authAndCheckAccessAndSetCRUContext(HttpServletRequest req, String projectKey, LLMStructuredRef llmRef) throws DKUSecurityException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authAndSetCRUContext(req, projectKey);
            if (llmRef.savedModelSmartId != null) {
                this.checkAccessSavedModel(authCtx, projectKey, llmRef.savedModelSmartId);
            }
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/completions"}, method={RequestMethod.POST})
    public CompletionsResponse runCompletions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        CompletionsRequest completionsRequest = (CompletionsRequest)this.getRequestBodyAs(req, CompletionsRequest.class);
        try {
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)completionsRequest.llmId);
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, llmRef);
            return this.getCompletionsResponse(req, projectKey, completionsRequest, authCtx);
        }
        catch (Exception e) {
            this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    private CompletionsResponse getCompletionsResponse(HttpServletRequest req, String projectKey, CompletionsRequest completionsRequest, AuthCtx authCtx) throws Exception {
        LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)completionsRequest.llmId);
        GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)completionsRequest.guardrails);
        if (this.bypassTokensService.hasValidBypassToken(req)) {
            logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
            guardrailsPipelineSettings = null;
        }
        try (LLMMeshClient llmMeshClient = LLMMeshClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef, (GuardrailsPipelineSettings)guardrailsPipelineSettings, null, (int)completionsRequest.queries.size());){
            EnrichedLLMStructuredRef enrichedLLMRef = llmMeshClient.getEnrichedRef();
            llmMeshClient.throwIfBadImageAuditFolder();
            List responses = llmMeshClient.completeQueries(completionsRequest.queries, completionsRequest.settings);
            ComputeResourceUsage cru = llmMeshClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION);
            if (cru != null) {
                this.cruReportingService.reportComplete(cru);
            }
            AbstractLLMConnection llmConnection = llmMeshClient.getConnection();
            ManagedFolder mf = null;
            if (llmConnection != null && llmConnection.getLLMConnectionParams().storeImages) {
                logger.info((Object)String.format("Storing images in '%s'.", llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                try (Transaction t = this.transactionService.beginRead();){
                    mf = (ManagedFolder)this.managedFolderDAO.getMandatory(AnyLoc.resolveFull((String)llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                }
            }
            for (int recordIdx = 0; recordIdx < responses.size(); ++recordIdx) {
                List<String> savedImagePaths = this.saveImageInputToManageFolder(completionsRequest.queries.get(recordIdx), mf);
                LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded((AuditTrailService)this.auditTrailService, (LLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmMeshClient.getConnection(), (LLMClient.SingleCompletionQuery)completionsRequest.queries.get(recordIdx), (LLMClient.SimpleCompletionResponseOrError)((LLMClient.SimpleCompletionResponseOrError)responses.get(recordIdx)), savedImagePaths);
            }
            CompletionsResponse ret = new CompletionsResponse();
            ret.responses = responses;
            CompletionsResponse completionsResponse = ret;
            return completionsResponse;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/streamed-completion"}, method={RequestMethod.POST})
    public void streamCompletion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        FullCompletionRequest request = (FullCompletionRequest)this.getRequestBodyAs(req, FullCompletionRequest.class);
        try {
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)request.llmId);
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, llmRef);
            this.streamCompletion(req, resp, projectKey, request, authCtx, new MiniSSEEmitter(resp, false), false, false);
        }
        catch (Exception e) {
            this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
            logger.warn((Object)"Got error from LLM", (Throwable)e);
            throw new IOException("Failed to stream LLM completion", e);
        }
    }

    private void streamCompletion(HttpServletRequest httpReq, HttpServletResponse resp, String projectKey, FullCompletionRequest request, AuthCtx authCtx, MiniSSEEmitter emitter, boolean isOpenAI, boolean includeUsage) throws Exception {
        block24: {
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)request.llmId);
            try (LLMClient llmClient = LLMClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);){
                llmClient.throwIfBadImageAuditFolder();
                GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
                GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)request.guardrails);
                if (this.bypassTokensService.hasValidBypassToken(httpReq)) {
                    logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
                    guardrailsPipelineSettings = null;
                }
                EnrichedLLMStructuredRef enrichedLLMRef = llmClient.getEnrichedRef();
                logger.info((Object)("Sending single completion query to LLM:  " + JSON.json((Object)request.query)));
                OpenAICompatibleStreamingChunkEmitter openAICompatibleStreamingChunkEmitter = new OpenAICompatibleStreamingChunkEmitter(emitter, isOpenAI, includeUsage, enrichedLLMRef);
                try (LLMMeshStreamClient streamClient = new LLMMeshStreamClient(authCtx, projectKey, enrichedLLMRef, guardrailsPipelineSettings, false, false, (StreamingChunkEmitter)openAICompatibleStreamingChunkEmitter);){
                    LLMClient.SimpleCompletionResponseOrError scre = streamClient.streamComplete(request.query, request.settings);
                    ComputeResourceUsage cru = streamClient.getTotalCRU();
                    if (cru != null) {
                        this.cruReportingService.reportComplete(cru);
                    }
                    AbstractLLMConnection llmConnection = llmClient.getConnection();
                    ManagedFolder mf = null;
                    if (llmConnection != null && llmConnection.getLLMConnectionParams().storeImages) {
                        logger.info((Object)String.format("Storing images in '%s'.", llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                        try (Transaction t = this.transactionService.beginRead();){
                            mf = (ManagedFolder)this.managedFolderDAO.getMandatory(AnyLoc.resolveFull((String)llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                        }
                    }
                    List<String> savedImagePaths = this.saveImageInputToManageFolder(request.query, mf);
                    LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded((AuditTrailService)this.auditTrailService, (LLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmClient.getConnection(), (LLMClient.SingleCompletionQuery)request.query, (LLMClient.SimpleCompletionResponseOrError)scre, savedImagePaths);
                    if (scre.ok) break block24;
                    if (isOpenAI && scre.errorType == LLMClient.LLMErrorType.REFUSAL) {
                        emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalChunk(request.llmId, openAICompatibleStreamingChunkEmitter.openAIResponseId, scre)), false);
                        emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalLastChunk(request.llmId, openAICompatibleStreamingChunkEmitter.openAIResponseId)), false);
                        if (includeUsage) {
                            emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalUsage(request.llmId, openAICompatibleStreamingChunkEmitter.openAIResponseId, scre)), false);
                        }
                        break block24;
                    }
                    if (scre.errorType == LLMClient.LLMErrorType.REFUSAL) {
                        throw new LLMClient.RefusalException(scre.errorMessage);
                    }
                    throw new Exception(scre.errorMessage);
                }
            }
        }
    }

    private List<String> saveImageInputToManageFolder(LLMClient.SingleCompletionQuery query, ManagedFolder mf) throws Exception {
        ArrayList<String> savedImagePaths = new ArrayList<String>();
        if (mf != null) {
            for (LLMClient.ChatMessagePart imagePart : query.getImageParts()) {
                if (imagePart.containsImageData()) {
                    ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler((AuthCtx)DSSAuthCtx.newNone());
                    try {
                        String savedImagePath = this.imageAuditService.saveImage(imagePart.getImageData(), ImageAuditManagedFolderService.ImageAuditSource.TEXT_GENERATION_INPUT, handler);
                        savedImagePaths.add(savedImagePath);
                        continue;
                    }
                    finally {
                        if (handler != null) {
                            handler.close();
                        }
                        continue;
                    }
                }
                savedImagePaths.add(imagePart.imageUrl);
            }
        }
        return savedImagePaths;
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/embeddings"}, method={RequestMethod.POST})
    public EmbeddingsResponse runEmbeddings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        EmbeddingsResponse embeddingsResponse;
        block11: {
            EmbeddingsRequest request = (EmbeddingsRequest)this.getRequestBodyAs(req, EmbeddingsRequest.class);
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)request.llmId);
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, llmRef);
            GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
            GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)request.guardrails);
            if (this.bypassTokensService.hasValidBypassToken(req)) {
                logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
                guardrailsPipelineSettings = null;
            }
            LLMMeshClient llmMeshClient = LLMMeshClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef, (GuardrailsPipelineSettings)guardrailsPipelineSettings, null, (int)request.queries.size());
            try {
                EnrichedLLMStructuredRef enrichedLLMRef = llmMeshClient.getEnrichedRef();
                List responses = llmMeshClient.embedQueries(request.queries, request.settings);
                HashSet<ComputeResourceUsage.LLMUsageType> requestUsagesTypes = new HashSet<ComputeResourceUsage.LLMUsageType>();
                int i = 0;
                for (LLMClient.EmbeddingQuery query : request.queries) {
                    ComputeResourceUsage.LLMUsageType queryUsageType = PublicAPILLMController.getEmbeddingLLMUsageType(query);
                    requestUsagesTypes.add(queryUsageType);
                    LLMAuditHelper.emitLLMEmbeddingAudit((AuditTrailService)this.auditTrailService, (EnrichedLLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmMeshClient.getConnection(), (ComputeResourceUsage.LLMUsageType)queryUsageType, (String)query.text, (LLMClient.SimpleEmbeddingResponseOrError)((LLMClient.SimpleEmbeddingResponseOrError)responses.get(i)));
                    ++i;
                }
                ComputeResourceUsage.LLMUsageType requestAggUsageType = requestUsagesTypes.size() == 1 ? (ComputeResourceUsage.LLMUsageType)requestUsagesTypes.iterator().next() : ComputeResourceUsage.LLMUsageType.MULTIMODAL_EMBEDDING_EXTRACTION;
                ComputeResourceUsage cru = llmMeshClient.getTotalCRU(requestAggUsageType);
                if (cru != null) {
                    this.cruReportingService.reportComplete(cru);
                }
                EmbeddingsResponse ret = new EmbeddingsResponse();
                ret.responses = responses;
                embeddingsResponse = ret;
                if (llmMeshClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (llmMeshClient != null) {
                        try {
                            llmMeshClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("llm-embeddings", (Throwable)e).with("projectKey", projectKey).emit();
                    throw e;
                }
            }
            llmMeshClient.close();
        }
        return embeddingsResponse;
    }

    /*
     * Exception decompiling
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/images"}, method={RequestMethod.POST})
    public LLMClient.ImageGenerationResponseOrError generateImage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ComputeResourceUsage.LLMUsageType getEmbeddingLLMUsageType(LLMClient.EmbeddingQuery query) {
        if (query.hasImage() && query.hasText()) {
            return ComputeResourceUsage.LLMUsageType.MULTIMODAL_EMBEDDING_EXTRACTION;
        }
        if (query.hasImage()) {
            return ComputeResourceUsage.LLMUsageType.IMAGE_EMBEDDING_EXTRACTION;
        }
        return ComputeResourceUsage.LLMUsageType.TEXT_EMBEDDING_EXTRACTION;
    }

    @AuditedCall(value={"msgType", "llm-mesh-llms-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms"}, method={RequestMethod.GET})
    public List<EnrichedLLMStructuredRef> listLLMs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="GENERIC_COMPLETION") String purpose) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.valueOf((String)purpose)).identifiers;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-llms-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/openai/v1/models"}, method={RequestMethod.GET})
    public OpenAIModels listOpenAIModels(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List openAIModelList = this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION).identifiers.stream().map(enrichedLLMStructuredRef -> {
                OpenAIModels.OpenAIModel openAIModel = new OpenAIModels.OpenAIModel();
                openAIModel.id = enrichedLLMStructuredRef.id;
                return openAIModel;
            }).collect(Collectors.toList());
            OpenAIModels openAIModels = new OpenAIModels();
            openAIModels.data = openAIModelList;
            OpenAIModels openAIModels2 = openAIModels;
            return openAIModels2;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/openai/v1/chat/completions"}, method={RequestMethod.POST})
    public void runOpenAICompletion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String requestURI = req.getRequestURI();
        try {
            OpenAIChatCompletionRequest openAIChatCompletionRequest = (OpenAIChatCompletionRequest)this.getRequestBodyAs(req, OpenAIChatCompletionRequest.class);
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)openAIChatCompletionRequest.model);
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey, llmRef);
            if (Boolean.TRUE.equals(openAIChatCompletionRequest.stream)) {
                this.openaiStreamCompletion(resp, projectKey, openAIChatCompletionRequest, authCtx, req);
            } else {
                CompletionsRequest completionsRequest = OpenAIAPIConverter.convertToCompletionRequest(openAIChatCompletionRequest);
                OpenAIChatCompletionResponse response = OpenAIAPIConverter.convertToOpenAIResponse(openAIChatCompletionRequest, this.getCompletionsResponse(req, projectKey, completionsRequest, authCtx));
                if (response.error != null && !Strings.isNullOrEmpty((String)response.error.message)) {
                    resp.setStatus(400);
                }
                PublicAPILLMController.writeJSON((HttpServletResponse)resp, (Object)response);
            }
        }
        catch (DKUSecurityException e) {
            this.writeOpenAIChatCompletionErrorResponse((Exception)((Object)e), projectKey, resp, 403, requestURI);
        }
        catch (DKUControllerBase.MalformedRequestException | IllegalArgumentException | UnsupportedOperationException e) {
            this.writeOpenAIChatCompletionErrorResponse((Exception)e, projectKey, resp, 400, requestURI);
        }
        catch (Exception e) {
            this.writeOpenAIChatCompletionErrorResponse(e, projectKey, resp, 500, requestURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void openaiStreamCompletion(HttpServletResponse resp, String projectKey, OpenAIChatCompletionRequest openAIChatCompletionRequest, AuthCtx authCtx, HttpServletRequest req) throws Exception {
        block14: {
            String requestURI = req.getRequestURI();
            try (MiniSSEEmitter emitter = new MiniSSEEmitter(resp, false);){
                try {
                    FullCompletionRequest request = OpenAIAPIConverter.convertToFullCompletionRequest(openAIChatCompletionRequest);
                    boolean includeUsage = Boolean.TRUE.equals(openAIChatCompletionRequest.stream) && openAIChatCompletionRequest.stream_options != null && Boolean.TRUE.equals(openAIChatCompletionRequest.stream_options.include_usage);
                    this.streamCompletion(req, resp, projectKey, request, authCtx, new MiniSSEEmitter(resp, false), true, includeUsage);
                }
                catch (DKUSecurityException e) {
                    this.writeOpenAIChatStreamCompletionErrorResponse((Exception)((Object)e), projectKey, resp, 403, emitter, requestURI);
                }
                catch (DKUControllerBase.MalformedRequestException | IllegalArgumentException | UnsupportedOperationException e) {
                    this.writeOpenAIChatStreamCompletionErrorResponse((Exception)e, projectKey, resp, 400, emitter, requestURI);
                }
                catch (Exception e2) {
                    this.writeOpenAIChatStreamCompletionErrorResponse(e2, projectKey, resp, 500, emitter, requestURI);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    emitter.sendEventWithData(null, "[DONE]", false);
                }
            }
        }
    }

    private void writeOpenAIChatStreamCompletionErrorResponse(Exception e, String projectKey, HttpServletResponse resp, int errorCode, MiniSSEEmitter emitter, String requestURI) throws Exception {
        this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
        this.logOpenAIAPIException(requestURI, e);
        OpenAIChatCompletionResponse errorResponse = new OpenAIChatCompletionResponse();
        errorResponse.error = new OpenAIChatCompletionResponse.OpenAIChatCompletionError();
        errorResponse.error.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
        resp.setStatus(errorCode);
        emitter.sendEventWithData(null, JSON.json((Object)errorResponse), false);
    }

    private void writeOpenAIChatCompletionErrorResponse(Exception e, String projectKey, HttpServletResponse resp, int errorCode, String requestURI) throws IOException {
        this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
        this.logOpenAIAPIException(requestURI, e);
        OpenAIChatCompletionResponse errorResponse = new OpenAIChatCompletionResponse();
        errorResponse.error = new OpenAIChatCompletionResponse.OpenAIChatCompletionError();
        errorResponse.error.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
        resp.setStatus(errorCode);
        PublicAPILLMController.writeJSON((HttpServletResponse)resp, (Object)errorResponse);
    }

    private void logOpenAIAPIException(String requestURI, Exception e) {
        if (PublicAPILLMController.exceptionStackIsWorthPrintingInLogs((Throwable)e)) {
            logger.error((Object)("API call '" + requestURI + "' failed"), (Throwable)e);
        } else {
            logger.error((Object)("API call '" + requestURI + "' failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    public static class CompletionsRequest {
        public String llmId;
        public List<LLMClient.SingleCompletionQuery> queries = new ArrayList<LLMClient.SingleCompletionQuery>();
        public LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
        public GuardrailsPipelineSettings guardrails;
    }

    public static class CompletionsResponse {
        public List<LLMClient.SimpleCompletionResponseOrError> responses = new ArrayList<LLMClient.SimpleCompletionResponseOrError>();
    }

    public static class FullCompletionRequest {
        public String llmId;
        public LLMClient.SingleCompletionQuery query;
        public LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
        public GuardrailsPipelineSettings guardrails;
    }

    public class OpenAICompatibleStreamingChunkEmitter
    extends StreamingChunkEmitter {
        final String openAIResponseId;
        private final boolean isOpenAI;
        private final boolean includeUsage;
        private final EnrichedLLMStructuredRef enrichedLLMRef;

        public OpenAICompatibleStreamingChunkEmitter(MiniSSEEmitter emitter, boolean isOpenAI, boolean includeUsage, EnrichedLLMStructuredRef enrichedLLMRef) {
            super(emitter);
            this.isOpenAI = isOpenAI;
            this.openAIResponseId = isOpenAI ? "chatcmpl-" + SecretKeyGenerator.generateSmall() : null;
            this.includeUsage = includeUsage;
            this.enrichedLLMRef = enrichedLLMRef;
        }

        public void emitCompletionChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
            if (this.isOpenAI) {
                this.miniSSEEmitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(this.enrichedLLMRef.id, this.openAIResponseId, chunk)), false);
            } else {
                super.emitCompletionChunk(chunk);
            }
        }

        public void emitCompletionFooter(LLMClient.StreamedCompletionResponseFooter footer) throws Exception {
            if (this.isOpenAI) {
                this.miniSSEEmitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(this.enrichedLLMRef.id, this.openAIResponseId, footer)), false);
                if (this.includeUsage) {
                    this.miniSSEEmitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkUsageResponse(this.enrichedLLMRef.id, this.openAIResponseId, footer)), false);
                }
            } else {
                super.emitCompletionFooter(footer);
            }
        }
    }

    static class EmbeddingsRequest {
        public String llmId;
        public List<LLMClient.EmbeddingQuery> queries = new ArrayList<LLMClient.EmbeddingQuery>();
        public LLMClient.EmbeddingSettings settings = new LLMClient.EmbeddingSettings();
        public GuardrailsPipelineSettings guardrails;

        EmbeddingsRequest() {
        }
    }

    static class EmbeddingsResponse {
        public List<LLMClient.SimpleEmbeddingResponseOrError> responses = new ArrayList<LLMClient.SimpleEmbeddingResponseOrError>();

        EmbeddingsResponse() {
        }
    }
}

