/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.code.ProjectLibrariesEditionService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.plugins.dev.FolderEditorService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIProjectLibrariesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectLibrariesEditionService projectLibrariesEditionService;
    @Autowired
    private FolderEditorService folderEditorService;
    @Autowired
    private GitReferencesService gitRefService;

    @AuditedCall(value={"msgType", "project-libraries-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/libraries/contents"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FolderEditorService.FolderContent> listProjectLibrariesContents(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        List ret;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            authCtx.failIfNoSafeCode("edit the contents of the project's libraries");
            ret = this.folderEditorService.getFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), (TransactionRef)t);
        }
        return this.projectLibrariesEditionService.autocompleteProjectLibrariesContent_NT(authCtx, projectKey, ret);
    }

    @AuditedCall(value={"msgType", "project-libraries-read", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/libraries/contents/**"}, method={RequestMethod.GET})
    @ResponseBody
    public FolderEditorService.FolderContent getFileContent(HttpServletRequest req, @PathVariable String projectKey, @RequestParam(required=false, defaultValue="") String dataEncoding) throws Exception {
        String itemPath = PublicAPIProjectLibrariesController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            authCtx.failIfNoSafeCode("edit the contents of the project's libraries");
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            FolderEditorService.FolderContent folderContent = this.folderEditorService.getFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), itemPath, true, dataEncoding, t);
            return folderContent;
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-write", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/contents/**"}, method={RequestMethod.POST})
    public void writeFileContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String itemPath = PublicAPIProjectLibrariesController.extractPathFromRequest((HttpServletRequest)req);
        if (Strings.isNullOrEmpty((String)itemPath)) {
            throw new IllegalArgumentException("No file path retrieved from request");
        }
        byte[] requestBodyAsByteArray = IOUtils.toByteArray((InputStream)req.getInputStream());
        String data = new String(requestBodyAsByteArray, StandardCharsets.UTF_8);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            t.getUser().failIfNoSafeCode("edit the contents of the project's libraries");
            this.folderEditorService.setOrAddFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), itemPath, data, t);
            t.commit("Edit project libraries file: " + itemPath);
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-write", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/folders/**"}, method={RequestMethod.POST})
    public void createFolder(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String folderPath = PublicAPIProjectLibrariesController.extractPathFromRequest((HttpServletRequest)req);
        if (Strings.isNullOrEmpty((String)folderPath)) {
            throw new IllegalArgumentException("No folder path retrieved from request");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            t.getUser().failIfNoSafeCode("edit the contents of the project's libraries");
            this.folderEditorService.addFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), folderPath, true, (RWTransactionRef)t);
            t.commit("Add new folder : " + folderPath);
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-rename", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/contents-actions/rename"}, method={RequestMethod.POST})
    public void renameFolderContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        RenameParameters renameParameters = (RenameParameters)this.getRequestBodyAs(req, RenameParameters.class);
        if (Strings.isNullOrEmpty((String)renameParameters.oldPath)) {
            throw new IllegalArgumentException("Old path should not be empty");
        }
        if (Strings.isNullOrEmpty((String)renameParameters.newName)) {
            throw new IllegalArgumentException("New name should not be empty");
        }
        if (renameParameters.newName.contains("/")) {
            throw new IllegalArgumentException("Invalid character '/' in " + renameParameters.newName);
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            t.getUser().failIfNoSafeCode("edit the contents of the project's libraries");
            this.folderEditorService.renameFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), renameParameters.oldPath, renameParameters.newName, t);
            t.commit("Rename " + renameParameters.oldPath + " to " + renameParameters.newName);
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-move", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/contents-actions/move"}, method={RequestMethod.POST})
    public void moveFolderContent(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        MoveParameters moveParameters = (MoveParameters)this.getRequestBodyAs(req, MoveParameters.class);
        if (Strings.isNullOrEmpty((String)moveParameters.oldPath)) {
            throw new IllegalArgumentException("Old path should not be empty");
        }
        if (Strings.isNullOrEmpty((String)moveParameters.newPath)) {
            throw new IllegalArgumentException("New path should not be empty");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            t.getUser().failIfNoSafeCode("edit the contents of the project's libraries");
            this.folderEditorService.moveFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), moveParameters.oldPath, moveParameters.newPath, t);
            t.commit("Move " + moveParameters.oldPath + " to " + moveParameters.newPath);
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-write", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/contents/**"}, method={RequestMethod.DELETE})
    public void deletePath(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String itemPath = PublicAPIProjectLibrariesController.extractPathFromRequest((HttpServletRequest)req);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkProjectPrivileges(t.getUser(), projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            t.getUser().failIfNoSafeCode("edit the contents of the project's libraries");
            this.folderEditorService.removeFolderContent(AdminEditionController.GlobalCodeZone.LIB.getPath(projectKey), itemPath, t);
            t.commit("Delete project libraries path: " + itemPath);
        }
    }

    @AuditedCall(value={"msgType", "project-libraries-write", "projectKey", "${projectKey}"})
    @RequestMapping(value={"publicapi/projects/{projectKey}/libraries/git-references/actions/pull/**"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> pullGitReference(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        AuthCtx authCtx;
        String gitRefPath = PublicAPIProjectLibrariesController.extractPathFromRequest((HttpServletRequest)req);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        return this.gitRefService.startPullProjectGitRef_NT(projectKey, gitRefPath, authCtx);
    }

    private static class RenameParameters {
        public String oldPath;
        public String newName;

        private RenameParameters() {
        }
    }

    private static class MoveParameters {
        public String oldPath;
        public String newPath;

        private MoveParameters() {
        }
    }
}

