/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class JsonFunctionUtils {
    static final JsonToken END_OF_STREAM = null;

    private JsonFunctionUtils() {
    }

    static void serializeContents(JsonParser parser, JsonGenerator generator) throws IOException {
        switch (parser.currentTokenId()) {
            case 3: {
                JsonFunctionUtils.serializeArray(parser, generator);
                break;
            }
            case 1: {
                JsonFunctionUtils.serializeObject(parser, generator);
            }
        }
    }

    static void serializeArray(JsonParser parser, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        JsonToken token = parser.nextToken();
        while (token != END_OF_STREAM && token != JsonToken.END_ARRAY) {
            switch (parser.currentTokenId()) {
                case 6: {
                    generator.writeString(parser.getText());
                    break;
                }
                case 8: {
                    generator.writeNumber(parser.getFloatValue());
                    break;
                }
                case 7: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case 9: 
                case 10: {
                    generator.writeBoolean(parser.getBooleanValue());
                    break;
                }
                default: {
                    JsonFunctionUtils.serializeContents(parser, generator);
                }
            }
            token = parser.nextToken();
        }
        generator.writeEndArray();
    }

    static void serializeObject(JsonParser parser, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        JsonToken token = parser.nextToken();
        while (token != END_OF_STREAM && token != JsonToken.END_OBJECT) {
            switch (parser.currentTokenId()) {
                case 5: {
                    generator.writeFieldName(parser.getCurrentName());
                    break;
                }
                case 6: {
                    generator.writeString(parser.getText());
                    break;
                }
                case 8: {
                    generator.writeNumber(parser.getFloatValue());
                    break;
                }
                case 7: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case 9: 
                case 10: {
                    generator.writeBoolean(parser.getBooleanValue());
                    break;
                }
                default: {
                    JsonFunctionUtils.serializeContents(parser, generator);
                }
            }
            token = parser.nextToken();
        }
        generator.writeEndObject();
    }
}

