/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.hproxy.server.utils;

import java.util.LinkedList;

class LinkedStringBuffer {
    private final LinkedList<String> list;
    private final int capacity;
    private int size;

    public LinkedStringBuffer(int capacity) {
        this.capacity = capacity;
        this.list = new LinkedList();
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void write(String data) {
        this.list.add(data);
        this.size += data.length();
        while (this.size > this.capacity) {
            String evicted = this.list.remove(0);
            this.size -= evicted.length();
        }
    }

    public synchronized String read() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.list) {
            sb.append(s);
        }
        return sb.toString();
    }

    public synchronized void clear() {
        this.list.clear();
        this.size = 0;
    }
}

