/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.AddCDCFile;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLogActionUtils {
    private static final Logger logger = LoggerFactory.getLogger(DeltaLogActionUtils.class);
    private static final String COMMIT_VERSION_COL_NAME = "version";
    private static final DataType COMMIT_VERSION_DATA_TYPE = LongType.LONG;
    private static final StructField COMMIT_VERSION_STRUCT_FIELD = new StructField("version", COMMIT_VERSION_DATA_TYPE, false);
    private static final String COMMIT_TIMESTAMP_COL_NAME = "timestamp";
    private static final DataType COMMIT_TIMESTAMP_DATA_TYPE = LongType.LONG;
    private static final StructField COMMIT_TIMESTAMP_STRUCT_FIELD = new StructField("timestamp", COMMIT_TIMESTAMP_DATA_TYPE, false);

    private DeltaLogActionUtils() {
    }

    public static List<FileStatus> getCommitFilesForVersionRange(Engine engine, Path path, long l, long l2) {
        if (l < 0L || l2 < l) {
            throw DeltaErrors.invalidVersionRange(l, l2);
        }
        List<FileStatus> list = DeltaLogActionUtils.listCommitFiles(engine, path, l, l2);
        if (list.isEmpty()) {
            throw DeltaErrors.noCommitFilesFoundForVersionRange(path.toString(), l, l2);
        }
        DeltaLogActionUtils.verifyDeltaVersions(list, l, l2, path);
        return list;
    }

    public static CloseableIterator<ColumnarBatch> readCommitFiles(Engine engine, List<FileStatus> list, StructType structType) {
        return new ActionsIterator(engine, list, structType, Optional.empty()).map(actionWrapper -> {
            long l = actionWrapper.getTimestamp().orElseThrow(() -> new RuntimeException("Commit files should always have a timestamp"));
            ExpressionEvaluator expressionEvaluator = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getEvaluator(structType, Literal.ofLong(actionWrapper.getVersion()), LongType.LONG), "Get the expression evaluator for the commit version", new Object[0]);
            ExpressionEvaluator expressionEvaluator2 = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getEvaluator(structType, Literal.ofLong(l), LongType.LONG), "Get the expression evaluator for the commit timestamp", new Object[0]);
            ColumnVector columnVector = DeltaErrors.wrapEngineException(() -> expressionEvaluator.eval(actionWrapper.getColumnarBatch()), "Evaluating the commit version expression", new Object[0]);
            ColumnVector columnVector2 = DeltaErrors.wrapEngineException(() -> expressionEvaluator2.eval(actionWrapper.getColumnarBatch()), "Evaluating the commit timestamp expression", new Object[0]);
            return actionWrapper.getColumnarBatch().withNewColumn(0, COMMIT_VERSION_STRUCT_FIELD, columnVector).withNewColumn(1, COMMIT_TIMESTAMP_STRUCT_FIELD, columnVector2);
        });
    }

    static void verifyDeltaVersions(List<FileStatus> list, long l, long l2, Path path) {
        List list2 = list.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toList());
        for (int i = 1; i < list2.size(); ++i) {
            if ((Long)list2.get(i) == (Long)list2.get(i - 1) + 1L) continue;
            throw new InvalidTableException(path.toString(), String.format("Missing delta files: versions are not contiguous: (%s)", list2));
        }
        if (list2.isEmpty() || !Objects.equals(list2.get(0), l)) {
            throw DeltaErrors.startVersionNotFound(path.toString(), l, list2.isEmpty() ? Optional.empty() : Optional.of(list2.get(0)));
        }
        if (list2.isEmpty() || !Objects.equals(list2.get(list2.size() - 1), l2)) {
            throw DeltaErrors.endVersionNotFound(path.toString(), l2, list2.isEmpty() ? Optional.empty() : Optional.of(list2.get(list2.size() - 1)));
        }
    }

    private static CloseableIterator<FileStatus> listLogDir(Engine engine, Path path, long l) {
        Path path2 = new Path(path, "_delta_log");
        try {
            return DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path2, l)), "Listing from %s", FileNames.listingPrefix(path2, l));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TableNotFoundException(path.toString());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to list the files in delta log", iOException);
        }
    }

    private static List<FileStatus> listCommitFiles(Engine engine, Path path, long l, long l2) {
        logger.info("{}: Listing the commit files for versions [{}, {}]", new Object[]{path, l, l2});
        long l3 = System.currentTimeMillis();
        ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
        try (CloseableIterator<FileStatus> closeableIterator = DeltaLogActionUtils.listLogDir(engine, path, l);){
            while (closeableIterator.hasNext()) {
                FileStatus fileStatus = closeableIterator.next();
                if (!FileNames.isCommitFile(Path.getName(fileStatus.getPath()))) {
                    logger.debug("Ignoring non-commit file {}", (Object)fileStatus.getPath());
                    continue;
                }
                if (FileNames.getFileVersion(new Path(fileStatus.getPath())) > l2) {
                    logger.debug("Stopping listing found file {} with version > {}=endVersion", (Object)fileStatus.getPath(), (Object)l2);
                    break;
                }
                arrayList.add(fileStatus);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Unable to close resource", iOException);
        }
        logger.info("{}: Took {} ms to list the commit files for versions [{}, {}]", new Object[]{path, System.currentTimeMillis() - l3, l, l2});
        return arrayList;
    }

    public static enum DeltaAction {
        REMOVE("remove", RemoveFile.FULL_SCHEMA),
        ADD("add", AddFile.FULL_SCHEMA),
        METADATA("metaData", Metadata.FULL_SCHEMA),
        PROTOCOL("protocol", Protocol.FULL_SCHEMA),
        COMMITINFO("commitInfo", CommitInfo.FULL_SCHEMA),
        CDC("cdc", AddCDCFile.FULL_SCHEMA);

        public final String colName;
        public final StructType schema;

        private DeltaAction(String string2, StructType structType) {
            this.colName = string2;
            this.schema = structType;
        }
    }
}

