/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.deletionvectors.Base85Codec;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DeletionVectorDescriptor {
    public static final String PATH_DV_MARKER = "p";
    public static final String INLINE_DV_MARKER = "i";
    public static final String UUID_DV_MARKER = "u";
    public static final StructType READ_SCHEMA = new StructType().add("storageType", (DataType)StringType.STRING, false).add("pathOrInlineDv", (DataType)StringType.STRING, false).add("offset", (DataType)IntegerType.INTEGER, true).add("sizeInBytes", (DataType)IntegerType.INTEGER, false).add("cardinality", (DataType)LongType.LONG, false);
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL = IntStream.range(0, READ_SCHEMA.length()).boxed().collect(Collectors.toMap(n -> READ_SCHEMA.at((int)n).getName(), n -> n));
    private static final String DELETION_VECTOR_FILE_NAME_CORE = "deletion_vector";
    private final String storageType;
    private final String pathOrInlineDv;
    private final Optional<Integer> offset;
    private final int sizeInBytes;
    private final long cardinality;

    public static DeletionVectorDescriptor fromRow(Row row) {
        if (row == null) {
            return null;
        }
        String string = InternalUtils.requireNonNull(row, 0, "storageType").getString(0);
        String string2 = InternalUtils.requireNonNull(row, 1, "pathOrInlineDv").getString(1);
        Optional<Object> optional = Optional.ofNullable(row.isNullAt(2) ? null : Integer.valueOf(row.getInt(2)));
        int n = InternalUtils.requireNonNull(row, 3, "sizeInBytes").getInt(3);
        long l = InternalUtils.requireNonNull(row, 4, "cardinality").getLong(4);
        return new DeletionVectorDescriptor(string, string2, optional, n, l);
    }

    public static DeletionVectorDescriptor fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        String string = InternalUtils.requireNonNull(columnVector.getChild(0), n, "storageType").getString(n);
        String string2 = InternalUtils.requireNonNull(columnVector.getChild(1), n, "pathOrInlineDv").getString(n);
        Optional<Object> optional = Optional.ofNullable(columnVector.getChild(2).isNullAt(n) ? null : Integer.valueOf(columnVector.getChild(2).getInt(n)));
        int n2 = InternalUtils.requireNonNull(columnVector.getChild(3), n, "sizeInBytes").getInt(n);
        long l = InternalUtils.requireNonNull(columnVector.getChild(4), n, "cardinality").getLong(n);
        return new DeletionVectorDescriptor(string, string2, optional, n2, l);
    }

    public DeletionVectorDescriptor(String string, String string2, Optional<Integer> optional, int n, long l) {
        this.storageType = string;
        this.pathOrInlineDv = string2;
        this.offset = optional;
        this.sizeInBytes = n;
        this.cardinality = l;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public String getPathOrInlineDv() {
        return this.pathOrInlineDv;
    }

    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public long getCardinality() {
        return this.cardinality;
    }

    public String getUniqueId() {
        String string = this.storageType + this.pathOrInlineDv;
        if (this.offset.isPresent()) {
            return string + "@" + this.offset;
        }
        return string;
    }

    public boolean isInline() {
        return this.storageType == INLINE_DV_MARKER;
    }

    public boolean isOnDisk() {
        return !this.isInline();
    }

    public byte[] inlineData() {
        Preconditions.checkArgument(this.isInline(), "Can't get data for an on-disk DV from the log.");
        return Base85Codec.decodeBytes(this.pathOrInlineDv, this.sizeInBytes);
    }

    public String getAbsolutePath(String string) {
        Preconditions.checkArgument(this.isOnDisk(), "Can't get a path for an inline deletion vector");
        if (this.storageType.equals(UUID_DV_MARKER)) {
            int n = this.pathOrInlineDv.length() - 20;
            String string2 = this.pathOrInlineDv.substring(0, n);
            String string3 = this.pathOrInlineDv.substring(n);
            UUID uUID = Base85Codec.decodeUUID(string3);
            return this.assembleDeletionVectorPath(string, uUID, string2).toString();
        }
        if (this.storageType.equals(PATH_DV_MARKER)) {
            try {
                URI uRI = new URI(this.pathOrInlineDv);
                Preconditions.checkArgument(uRI.isAbsolute(), "Relative URIs are not supported for DVs");
                return new Path(uRI).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Couldn't parse uri:\n" + uRISyntaxException);
            }
        }
        throw new RuntimeException("A uri " + this.pathOrInlineDv + " which cannot be turned into a relative path as found in the transaction log");
    }

    private Path assembleDeletionVectorPath(String string, UUID uUID, String string2) {
        String string3 = String.format("%s_%s.bin", DELETION_VECTOR_FILE_NAME_CORE, uUID.toString());
        if (string2.length() > 0) {
            return new Path(new Path(string, string2), string3);
        }
        return new Path(string, string3);
    }

    public String toString() {
        return String.format("DeletionVectorDescriptor(storageType=%s, pathOrInlineDv=%s, offset=%s, sizeInBytes=%s, cardinality=%s)", this.storageType, this.pathOrInlineDv, this.offset, this.sizeInBytes, this.cardinality);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DeletionVectorDescriptor)) {
            return false;
        }
        DeletionVectorDescriptor deletionVectorDescriptor = (DeletionVectorDescriptor)object;
        return Objects.equals(this.storageType, deletionVectorDescriptor.storageType) && Objects.equals(this.pathOrInlineDv, deletionVectorDescriptor.pathOrInlineDv) && Objects.equals(this.offset, deletionVectorDescriptor.offset) && this.sizeInBytes == deletionVectorDescriptor.sizeInBytes && this.cardinality == deletionVectorDescriptor.cardinality;
    }

    public int hashCode() {
        return Objects.hash(this.storageType, this.pathOrInlineDv, this.offset, this.sizeInBytes, this.cardinality);
    }
}

