/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.coordinatedcommits.actions.AbstractCommitInfo;
import io.delta.kernel.internal.coordinatedcommits.actions.AbstractMetadata;
import io.delta.kernel.internal.coordinatedcommits.actions.AbstractProtocol;
import io.delta.kernel.internal.util.VectorUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CoordinatedCommitsUtils {
    public static AbstractMetadata convertMetadataToAbstractMetadata(final Metadata metadata) {
        return new AbstractMetadata(){

            @Override
            public String getId() {
                return metadata.getId();
            }

            @Override
            public String getName() {
                return metadata.getName().orElse(null);
            }

            @Override
            public String getDescription() {
                return metadata.getDescription().orElse(null);
            }

            @Override
            public String getProvider() {
                return metadata.getFormat().getProvider();
            }

            @Override
            public Map<String, String> getFormatOptions() {
                return metadata.getFormat().getOptions();
            }

            @Override
            public String getSchemaString() {
                return metadata.getSchemaString();
            }

            @Override
            public List<String> getPartitionColumns() {
                return VectorUtils.toJavaList(metadata.getPartitionColumns());
            }

            @Override
            public Map<String, String> getConfiguration() {
                return metadata.getConfiguration();
            }

            @Override
            public Optional<Long> getCreatedTime() {
                return metadata.getCreatedTime();
            }
        };
    }

    public static AbstractProtocol convertProtocolToAbstractProtocol(final Protocol protocol) {
        return new AbstractProtocol(){

            @Override
            public int getMinReaderVersion() {
                return protocol.getMinReaderVersion();
            }

            @Override
            public int getMinWriterVersion() {
                return protocol.getMinWriterVersion();
            }

            @Override
            public Set<String> getReaderFeatures() {
                return new HashSet<String>(protocol.getReaderFeatures());
            }

            @Override
            public Set<String> getWriterFeatures() {
                return new HashSet<String>(protocol.getWriterFeatures());
            }
        };
    }

    public static AbstractCommitInfo convertCommitInfoToAbstractCommitInfo(CommitInfo commitInfo) {
        return () -> commitInfo.getInCommitTimestamp().orElse(commitInfo.getTimestamp());
    }
}

