/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.linalg.SparseVector;
import com.dataiku.scoring.linalg.Vector;
import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreprocessingPipeline
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Map<String, Integer> columnMapping;
    private final List<Processor> stages;

    public PreprocessingPipeline(String[] outputColumns, List<Processor> stages) {
        this.stages = stages;
        this.columnMapping = new HashMap<String, Integer>();
        for (int i = 0; i < outputColumns.length; ++i) {
            this.columnMapping.put(outputColumns[i], i);
        }
    }

    public List<Processor> getStages() {
        return Collections.unmodifiableList(this.stages);
    }

    public Map<String, Integer> getColumnMapping() {
        return this.columnMapping;
    }

    public String[] getOutputColumns() {
        String[] columns = new String[this.columnMapping.size()];
        for (Map.Entry<String, Integer> e : this.columnMapping.entrySet()) {
            columns[e.getValue().intValue()] = e.getKey();
        }
        return columns;
    }

    public Try<Vector> process(RawObservation data) {
        for (Processor p : this.stages) {
            p.process(data);
            if (!data.hasError()) continue;
            return Try.failure("Failed to preprocess data: " + data.getErrorMessage());
        }
        HashMap<Integer, Double> sv = new HashMap<Integer, Double>();
        for (Map.Entry<String, Object> e : data.toMap().entrySet()) {
            Integer i = this.columnMapping.get(e.getKey());
            if (i == null) continue;
            sv.put(i, (Double)e.getValue());
        }
        return Try.success(new SparseVector(sv, this.columnMapping.size()));
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("PreprocessingPipeline(\n");
        for (Processor p : this.stages) {
            s.append("\t").append(p.toString()).append("\n");
        }
        return s.append(")").toString();
    }
}

